package com.steammachine.propertyeditor.utils;

import static java.util.Arrays.asList;
import static java.util.Collections.unmodifiableSet;

import com.steammachine.propertyeditor.types.EditorTags;
import com.steammachine.propertyeditor.types.EditorTags.Tag;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class EditorTagsUtils {

    public static Set<Tag> propertyEditorTags(Class aClass) {
        Class current = aClass;
        List<Class> ladder = new LinkedList<>();
        while (current != null) {
            ladder.add(0, current);
            current = current.getSuperclass();
        }
        Set<Tag> result = new HashSet<>();
        ladder.stream().forEachOrdered(clazz -> {
            EditorTags annotation = (EditorTags) clazz
                    .getAnnotation(EditorTags.class);
            if (annotation != null) {
                result.addAll(asList(annotation.include()));
                result.removeAll(asList(annotation.exclude()));
            }
        });
        return unmodifiableSet(result);
    }

    public static boolean hasTag(Class clazz, Tag property) {
        return propertyEditorTags(clazz).contains(property);
    }
}
