package com.steammachine.propertyeditor.baseeditors;

import static com.steammachine.propertyeditor.types.EditorTags.Tag.VALUE_NULLABLE;

import com.steammachine.propertyeditor.types.EditorTags;
import com.steammachine.propertyeditor.types.Selection;

@EditorTags(include = VALUE_NULLABLE)
public class IntegerProperty extends DefaultPropertyEditor<Integer> {

    public IntegerProperty(String name, Class<Integer> type, Selection selection) {
        super(name, type, selection);
    }

    @Override
    public String getAt(int index) {
        Integer valueAt = getValueAt(index);
        return valueAt != null ? "" + valueAt : null;
    }

    @Override
    public void set(String value) {
        setValue(value == null ? null : Integer.valueOf(value));
    }
}
