package com.steammachine.propertyeditor.types;

import com.steammachine.propertyeditor.types.exceptions.EditorNotFound;
import java.util.List;
import java.util.Optional;

public interface PropertyEditors {

    <T> Optional<PropertyEditor<T>> findEditor(String propertyName, Class<T> type);

    Optional<PropertyEditor> findEditor(String propertyName);

    List<PropertyEditor> getEditors();

    default <T> PropertyEditor<T> getEditor(String propertyName, Class<T> type)
            throws EditorNotFound {
        return findEditor(propertyName, type).orElseThrow(EditorNotFound::new);
    }

    default PropertyEditor getEditor(String propertyName) throws EditorNotFound {
        return findEditor(propertyName).orElseThrow(EditorNotFound::new);
    }


}
