package com.steammachine.propertyeditor.utils;

import static java.util.Objects.requireNonNull;

import java.util.function.Function;
import java.util.function.Supplier;

public class CommonUtils {

    public interface Func<R> {
        R evaluate() throws Throwable;
    }

    public interface Proc {
        void execute() throws Throwable;
    }



    public static <T extends Throwable> void check(boolean condition, Supplier<T> func) throws T {
        if (!condition) {
            throw requireNonNull(func).get();
        }
    }

    public static <R, T extends Throwable> R
    wrapFunc(Func<R> func, Function<Throwable, T> function) throws T {
        try {
            return func.evaluate();
        } catch (Throwable t) {
            throw function.apply(t);
        }
    }

    public static <T extends Throwable>
    void wrapProc(Proc procedure, Function<Throwable, T> function) throws T {
        try {
            procedure.execute();
        } catch (Throwable t) {
            throw function.apply(t);
        }
    }


}
