/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.propertyeditor.baseeditors;

import com.steammachine.propertyeditor.baseeditors.DefaultPropertyEditor;
import com.steammachine.propertyeditor.types.Selection;
import java.util.Arrays;
import java.util.function.Consumer;

public class EnumProperty
extends DefaultPropertyEditor<Enum> {
    public EnumProperty(String name, Class<Enum> type, Selection selection) {
        super(name, type, selection);
    }

    @Override
    public String getAt(int index) {
        return ((Enum)this.getValueAt(index)).name();
    }

    @Override
    public void set(String value) {
        this.setValue(Enum.valueOf(this.propertyType(), value));
    }

    @Override
    public void getValues(Consumer<String> proc) {
        Arrays.stream(this.propertyType().getEnumConstants()).map(Enum::name).forEachOrdered(proc);
    }
}

