/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.propertyeditor;

import com.steammachine.propertyeditor.baseeditors.BooleanProperty;
import com.steammachine.propertyeditor.baseeditors.ByteProperty;
import com.steammachine.propertyeditor.baseeditors.ClassProperty;
import com.steammachine.propertyeditor.baseeditors.DefaultPropertyEditors;
import com.steammachine.propertyeditor.baseeditors.EnumProperty;
import com.steammachine.propertyeditor.baseeditors.IntegerProperty;
import com.steammachine.propertyeditor.baseeditors.LongProperty;
import com.steammachine.propertyeditor.baseeditors.PrimitiveBooleanProperty;
import com.steammachine.propertyeditor.baseeditors.PrimitiveByteProperty;
import com.steammachine.propertyeditor.baseeditors.PrimitiveIntegerProperty;
import com.steammachine.propertyeditor.baseeditors.PrimitiveLongProperty;
import com.steammachine.propertyeditor.baseeditors.PrimitiveShortProperty;
import com.steammachine.propertyeditor.baseeditors.ShortProperty;
import com.steammachine.propertyeditor.baseeditors.StringProperty;
import com.steammachine.propertyeditor.types.PropertyEditor;
import com.steammachine.propertyeditor.types.PropertyEditorFactory;
import com.steammachine.propertyeditor.types.PropertyEditors;
import com.steammachine.propertyeditor.types.Selection;
import com.steammachine.propertyeditor.utils.CommonUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class EditorsUtils {
    private static final Map<Class, PropertyEditorFactory> EDITORS = new HashMap<Class, PropertyEditorFactory>();

    private static <T> void register(Class<T> type, PropertyEditorFactory<T> factory) {
        EDITORS.put(type, factory);
    }

    private EditorsUtils() {
    }

    public static PropertyEditors getEditors(Selection selection) {
        return new DefaultPropertyEditors(EditorsUtils.collectProperties(selection).stream().filter(propertyDefinition -> EditorsUtils.getPropertyEditorFactory(propertyDefinition.getPropertyType()) != null).map(propertyDefinition -> new PropertyInfo((PropertyDefinition)propertyDefinition, EditorsUtils.getPropertyEditorFactory(propertyDefinition.getPropertyType()))).map(t -> t.getPropertyEditorFactory().newPropertyEditor(t.getPropertyDefinition().getName(), t.getPropertyDefinition().getPropertyType(), selection)).sorted(Comparator.comparing(PropertyEditor::propertyName)).collect(Collectors.toList()));
    }

    static Set<PropertyDefinition> collectProperties(Selection selection) {
        CommonUtils.check(selection.hasElements(), IllegalStateException::new);
        Map<String, SelectionItem> getters = EditorsUtils.reduceProps(StreamSupport.stream(selection.spliterator(), false).map(object -> Arrays.stream(object.getClass().getMethods()).filter(method -> method.getReturnType() != Void.TYPE).filter(method -> method.getParameterCount() == 0).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> !Modifier.isAbstract(method.getModifiers())).filter(EditorsUtils::isGetter).filter(method -> EditorsUtils.getterPropName(method).length() > 0).map(method -> new SelectionItem(EditorsUtils.getterPropName(method), method.getReturnType())).map(selectionItem -> {
            HashMap<String, SelectionItem> map = new HashMap<String, SelectionItem>();
            map.put(selectionItem.getPropertyName(), (SelectionItem)selectionItem);
            return map;
        }).reduce(new HashMap(), EditorsUtils::mergeMaps)).collect(Collectors.toList()));
        Map<String, SelectionItem> setters = EditorsUtils.reduceProps(StreamSupport.stream(selection.spliterator(), false).map(object -> Arrays.stream(object.getClass().getMethods()).filter(method -> method.getReturnType() == Void.TYPE).filter(method -> method.getParameterCount() == 1).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> !Modifier.isAbstract(method.getModifiers())).filter(EditorsUtils::isSetter).filter(method -> EditorsUtils.setterPropName(method).length() > 0).map(method -> new SelectionItem(EditorsUtils.setterPropName(method), method.getParameterTypes()[0])).map(selectionItem -> {
            HashMap<String, SelectionItem> map = new HashMap<String, SelectionItem>();
            map.put(selectionItem.getPropertyName(), (SelectionItem)selectionItem);
            return map;
        }).reduce(new HashMap(), EditorsUtils::mergeMaps)).collect(Collectors.toList()));
        return getters.values().stream().map(item -> new PropertyDefinition(item.getPropertyName(), !setters.containsKey(item.getPropertyName()), item.getParamType())).collect(Collectors.toSet());
    }

    private static Map<String, SelectionItem> reduceProps(List<Map<String, SelectionItem>> properties) {
        CommonUtils.check(!properties.isEmpty(), IllegalStateException::new);
        Map<String, SelectionItem> result = properties.get(0);
        for (int i = 1; i < properties.size(); ++i) {
            Map<String, SelectionItem> current = properties.get(i);
            result.keySet().retainAll(current.keySet());
            for (Map.Entry<String, SelectionItem> entry : current.entrySet()) {
                SelectionItem selectionItem = result.get(entry.getKey());
                if (selectionItem == null || EditorsUtils.typesCompatible(selectionItem.paramType, entry.getValue().paramType)) continue;
                current.remove(entry.getKey());
            }
        }
        return result;
    }

    private static boolean typesCompatible(Class<?> paramType, Class<?> paramType1) {
        return paramType == paramType1;
    }

    private static Map<String, SelectionItem> mergeMaps(Map<String, SelectionItem> map, Map<String, SelectionItem> map2) {
        HashMap<String, SelectionItem> result = new HashMap<String, SelectionItem>(map);
        result.putAll(map2);
        return result;
    }

    public static boolean isGetter(Method method) {
        return method.getReturnType() == Boolean.TYPE && method.getName().startsWith("is") || method.getName().startsWith("get");
    }

    public static boolean isSetter(Method method) {
        return method.getName().startsWith("set");
    }

    private static PropertyEditorFactory getPropertyEditorFactory(Class paramType) {
        while (paramType != null) {
            PropertyEditorFactory propertyEditorFactory = EDITORS.get(paramType);
            if (propertyEditorFactory != null) {
                return propertyEditorFactory;
            }
            paramType = paramType.getSuperclass();
        }
        return null;
    }

    public static String getterPropName(Method method) {
        String name;
        if (method.getName().startsWith("is")) {
            name = method.getName().substring("is".length());
        } else if (method.getName().startsWith("get")) {
            name = method.getName().substring("get".length());
        } else {
            throw new IllegalStateException();
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static String setterPropName(Method method) {
        CommonUtils.check(method.getName().startsWith("set"), IllegalStateException::new);
        String name = method.getName().substring("set".length());
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    static {
        EditorsUtils.register(Class.class, ClassProperty::new);
        EditorsUtils.register(String.class, StringProperty::new);
        EditorsUtils.register(Enum.class, EnumProperty::new);
        EditorsUtils.register(Boolean.TYPE, PrimitiveBooleanProperty::new);
        EditorsUtils.register(Boolean.class, BooleanProperty::new);
        EditorsUtils.register(Byte.TYPE, PrimitiveByteProperty::new);
        EditorsUtils.register(Byte.class, ByteProperty::new);
        EditorsUtils.register(Short.TYPE, PrimitiveShortProperty::new);
        EditorsUtils.register(Short.class, ShortProperty::new);
        EditorsUtils.register(Integer.TYPE, PrimitiveIntegerProperty::new);
        EditorsUtils.register(Integer.class, IntegerProperty::new);
        EditorsUtils.register(Long.TYPE, PrimitiveLongProperty::new);
        EditorsUtils.register(Long.class, LongProperty::new);
    }

    private static class PropertyInfo {
        PropertyDefinition propertyDefinition;
        PropertyEditorFactory propertyEditorFactory;

        public PropertyDefinition getPropertyDefinition() {
            return this.propertyDefinition;
        }

        public PropertyEditorFactory getPropertyEditorFactory() {
            return this.propertyEditorFactory;
        }

        public void setPropertyDefinition(PropertyDefinition propertyDefinition) {
            this.propertyDefinition = propertyDefinition;
        }

        public void setPropertyEditorFactory(PropertyEditorFactory propertyEditorFactory) {
            this.propertyEditorFactory = propertyEditorFactory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyInfo)) {
                return false;
            }
            PropertyInfo other = (PropertyInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PropertyDefinition this$propertyDefinition = this.getPropertyDefinition();
            PropertyDefinition other$propertyDefinition = other.getPropertyDefinition();
            if (this$propertyDefinition == null ? other$propertyDefinition != null : !((Object)this$propertyDefinition).equals(other$propertyDefinition)) {
                return false;
            }
            PropertyEditorFactory this$propertyEditorFactory = this.getPropertyEditorFactory();
            PropertyEditorFactory other$propertyEditorFactory = other.getPropertyEditorFactory();
            return !(this$propertyEditorFactory == null ? other$propertyEditorFactory != null : !this$propertyEditorFactory.equals(other$propertyEditorFactory));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertyInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PropertyDefinition $propertyDefinition = this.getPropertyDefinition();
            result = result * 59 + ($propertyDefinition == null ? 43 : ((Object)$propertyDefinition).hashCode());
            PropertyEditorFactory $propertyEditorFactory = this.getPropertyEditorFactory();
            result = result * 59 + ($propertyEditorFactory == null ? 43 : $propertyEditorFactory.hashCode());
            return result;
        }

        public String toString() {
            return "EditorsUtils.PropertyInfo(propertyDefinition=" + this.getPropertyDefinition() + ", propertyEditorFactory=" + this.getPropertyEditorFactory() + ")";
        }

        public PropertyInfo(PropertyDefinition propertyDefinition, PropertyEditorFactory propertyEditorFactory) {
            this.propertyDefinition = propertyDefinition;
            this.propertyEditorFactory = propertyEditorFactory;
        }
    }

    static class PropertyDefinition {
        private final String name;
        private final boolean readOnly;
        private final Class propertyType;

        public String getName() {
            return this.name;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public Class getPropertyType() {
            return this.propertyType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyDefinition)) {
                return false;
            }
            PropertyDefinition other = (PropertyDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            if (this.isReadOnly() != other.isReadOnly()) {
                return false;
            }
            Class this$propertyType = this.getPropertyType();
            Class other$propertyType = other.getPropertyType();
            return !(this$propertyType == null ? other$propertyType != null : !this$propertyType.equals(other$propertyType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PropertyDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + (this.isReadOnly() ? 79 : 97);
            Class $propertyType = this.getPropertyType();
            result = result * 59 + ($propertyType == null ? 43 : $propertyType.hashCode());
            return result;
        }

        public String toString() {
            return "EditorsUtils.PropertyDefinition(name=" + this.getName() + ", readOnly=" + this.isReadOnly() + ", propertyType=" + this.getPropertyType() + ")";
        }

        public PropertyDefinition(String name, boolean readOnly, Class propertyType) {
            this.name = name;
            this.readOnly = readOnly;
            this.propertyType = propertyType;
        }
    }

    private static class SelectionItem {
        final String propertyName;
        final Class<?> paramType;

        public String getPropertyName() {
            return this.propertyName;
        }

        public Class<?> getParamType() {
            return this.paramType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelectionItem)) {
                return false;
            }
            SelectionItem other = (SelectionItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$propertyName = this.getPropertyName();
            String other$propertyName = other.getPropertyName();
            if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
                return false;
            }
            Class<?> this$paramType = this.getParamType();
            Class<?> other$paramType = other.getParamType();
            return !(this$paramType == null ? other$paramType != null : !this$paramType.equals(other$paramType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SelectionItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $propertyName = this.getPropertyName();
            result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            Class<?> $paramType = this.getParamType();
            result = result * 59 + ($paramType == null ? 43 : $paramType.hashCode());
            return result;
        }

        public String toString() {
            return "EditorsUtils.SelectionItem(propertyName=" + this.getPropertyName() + ", paramType=" + this.getParamType() + ")";
        }

        public SelectionItem(String propertyName, Class<?> paramType) {
            this.propertyName = propertyName;
            this.paramType = paramType;
        }
    }
}

