/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.propertyeditor.baseeditors;

import com.steammachine.propertyeditor.EditorsUtils;
import com.steammachine.propertyeditor.types.EditorTags;
import com.steammachine.propertyeditor.types.PropertyEditor;
import com.steammachine.propertyeditor.types.Selection;
import com.steammachine.propertyeditor.types.Value;
import com.steammachine.propertyeditor.types.exceptions.NullValueIsNotAllowed;
import com.steammachine.propertyeditor.types.exceptions.UnableToSetReadonlyProperty;
import com.steammachine.propertyeditor.types.exceptions.UnableToSetValue;
import com.steammachine.propertyeditor.utils.CommonUtils;
import com.steammachine.propertyeditor.utils.EditorTagsUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class DefaultPropertyEditor<T>
implements PropertyEditor<T> {
    private final String name;
    private final Selection selection;
    private final Class<T> type;
    private final List<Value<T>> dataList;
    private final Set<EditorTags.Tag> editorTags = EditorTagsUtils.propertyEditorTags(this.getClass());

    DefaultPropertyEditor(String name, Class<T> type, Selection selection) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.selection = Objects.requireNonNull(selection);
        this.dataList = StreamSupport.stream(selection.spliterator(), false).map(o -> {
            Method getter = Arrays.stream(o.getClass().getMethods()).filter(method -> method.getReturnType() == type).filter(EditorsUtils::isGetter).filter(method -> EditorsUtils.getterPropName(method).equals(name)).findFirst().orElseThrow(IllegalStateException::new);
            Method setter = Arrays.stream(o.getClass().getMethods()).filter(EditorsUtils::isSetter).filter(method -> EditorsUtils.setterPropName(method).equals(name)).filter(method -> method.getParameterCount() == 1).filter(method -> method.getParameterTypes()[0] == type).findFirst().orElse(null);
            return new ValueItem(o, getter, setter);
        }).collect(Collectors.toList());
    }

    @Override
    public void setValue(T value) {
        CommonUtils.check(!this.isReadOnly(), UnableToSetReadonlyProperty::new);
        CommonUtils.check(value != null || this.hasTag(EditorTags.Tag.VALUE_NULLABLE), NullValueIsNotAllowed::new);
        this.dataList.forEach(item -> CommonUtils.wrapProc(() -> item.set(value), UnableToSetValue::new));
    }

    @Override
    public boolean isReadOnly() {
        return this.hasTag(EditorTags.Tag.READ_ONLY) || this.dataList.get(0).isReadOnly();
    }

    private boolean hasTag(EditorTags.Tag tag) {
        return this.editorTags.contains((Object)tag);
    }

    protected int propertyCount() {
        return this.dataList.size();
    }

    @Override
    public T getValueAt(int index) {
        return this.dataList.get(index).get();
    }

    public String getName() {
        return this.name;
    }

    public Selection getSelection() {
        return this.selection;
    }

    @Override
    public Class<T> propertyType() {
        return this.type;
    }

    @Override
    public boolean allEquals() {
        if (this.propertyCount() == 1) {
            return true;
        }
        Object first = this.getValueAt(0);
        return Stream.iterate(1, i -> i + 1).limit((long)this.propertyCount() - 1L).map(this::getValueAt).allMatch(t -> Objects.equals(first, t));
    }

    @Override
    public String propertyName() {
        return this.name;
    }

    private static class ValueItem<T>
    implements Value<T> {
        private final Object nexus;
        private final Method getter;
        private final Method setter;

        @Override
        public void set(T value) {
            CommonUtils.wrapProc(() -> this.getSetter().invoke(this.nexus, value), thr -> new IllegalStateException());
        }

        @Override
        public T get() {
            return (T)CommonUtils.wrapFunc(() -> this.getGetter().invoke(this.nexus, new Object[0]), IllegalStateException::new);
        }

        @Override
        public boolean isReadOnly() {
            return this.setter == null;
        }

        public Object getNexus() {
            return this.nexus;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueItem)) {
                return false;
            }
            ValueItem other = (ValueItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$nexus = this.getNexus();
            Object other$nexus = other.getNexus();
            if (this$nexus == null ? other$nexus != null : !this$nexus.equals(other$nexus)) {
                return false;
            }
            Method this$getter = this.getGetter();
            Method other$getter = other.getGetter();
            if (this$getter == null ? other$getter != null : !((Object)this$getter).equals(other$getter)) {
                return false;
            }
            Method this$setter = this.getSetter();
            Method other$setter = other.getSetter();
            return !(this$setter == null ? other$setter != null : !((Object)this$setter).equals(other$setter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ValueItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $nexus = this.getNexus();
            result = result * 59 + ($nexus == null ? 43 : $nexus.hashCode());
            Method $getter = this.getGetter();
            result = result * 59 + ($getter == null ? 43 : ((Object)$getter).hashCode());
            Method $setter = this.getSetter();
            result = result * 59 + ($setter == null ? 43 : ((Object)$setter).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultPropertyEditor.ValueItem(nexus=" + this.getNexus() + ", getter=" + this.getGetter() + ", setter=" + this.getSetter() + ")";
        }

        public ValueItem(Object nexus, Method getter, Method setter) {
            this.nexus = nexus;
            this.getter = getter;
            this.setter = setter;
        }
    }
}

