/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.propertyeditor.baseeditors;

import com.steammachine.propertyeditor.types.PropertyEditor;
import com.steammachine.propertyeditor.types.PropertyEditors;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultPropertyEditors
implements PropertyEditors {
    private final List<PropertyEditor> ordered;
    private final Map<String, PropertyEditor> properties;

    public DefaultPropertyEditors(List<PropertyEditor> editorsList) {
        this.ordered = editorsList.stream().sorted(Comparator.comparing(PropertyEditor::propertyName)).collect(Collectors.toList());
        this.properties = editorsList.stream().collect(Collectors.toMap(PropertyEditor::propertyName, Function.identity()));
    }

    @Override
    public Optional<PropertyEditor> findEditor(String propertyName) {
        return Optional.ofNullable(this.properties.get(propertyName));
    }

    @Override
    public <T> Optional<PropertyEditor<T>> findEditor(String propertyName, Class<T> type) {
        return this.findEditor(propertyName).filter(editor -> editor.propertyType() == type).map(editor -> editor);
    }

    @Override
    public List<PropertyEditor> getEditors() {
        return this.ordered;
    }
}

