/*
 * Decompiled with CFR 0.152.
 */
package com.steammachine.propertyeditor.utils;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class CommonUtils {
    public static <T extends Throwable> void check(boolean condition, Supplier<T> func) throws T {
        if (!condition) {
            throw (Throwable)Objects.requireNonNull(func).get();
        }
    }

    public static <R, T extends Throwable> R wrapFunc(Func<R> func, Function<Throwable, T> function) throws T {
        try {
            return func.evaluate();
        }
        catch (Throwable t) {
            throw (Throwable)function.apply(t);
        }
    }

    public static <T extends Throwable> void wrapProc(Proc procedure, Function<Throwable, T> function) throws T {
        try {
            procedure.execute();
        }
        catch (Throwable t) {
            throw (Throwable)function.apply(t);
        }
    }

    public static interface Proc {
        public void execute() throws Throwable;
    }

    public static interface Func<R> {
        public R evaluate() throws Throwable;
    }
}

