/*
 * Decompiled with CFR 0.152.
 */
package net.jini.constraint;

import [Lnet.jini.constraint.BasicMethodConstraints;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;

public final class BasicMethodConstraints
implements MethodConstraints,
Serializable {
    private static final long serialVersionUID = 1432234194703790047L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descs", BasicMethodConstraints.MethodDesc;.class, true)};
    private final MethodDesc[] descs;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Class;
    static /* synthetic */ Class class$net$jini$core$constraint$InvocationConstraints;

    public BasicMethodConstraints(MethodDesc[] descs) {
        this.descs = (MethodDesc[])descs.clone();
        this.check();
    }

    private void check() {
        if (this.descs.length == 0) {
            throw new IllegalArgumentException("must have at least one descriptor");
        }
        for (int i = 0; i < this.descs.length; ++i) {
            String pname;
            int j;
            MethodDesc desc = this.descs[i];
            String dname = desc.name;
            if (dname == null) {
                if (i >= this.descs.length - 1) continue;
                throw new IllegalArgumentException("default descriptor must be last");
            }
            if (dname.charAt(0) == '*') {
                int dlen = dname.length() + 1;
                for (int j2 = 0; j2 < i; ++j2) {
                    MethodDesc prev = this.descs[j2];
                    String pname2 = prev.name;
                    if (pname2.charAt(0) != '*' || !pname2.regionMatches(1, dname, dlen - pname2.length(), pname2.length() - 1)) continue;
                    BasicMethodConstraints.check(prev, desc);
                }
                continue;
            }
            if (dname.charAt(dname.length() - 1) == '*') {
                for (j = 0; j < i; ++j) {
                    MethodDesc prev = this.descs[j];
                    pname = prev.name;
                    int plen = pname.length() - 1;
                    if (pname.charAt(plen) != '*' || !pname.regionMatches(0, dname, 0, plen)) continue;
                    BasicMethodConstraints.check(prev, desc);
                }
                continue;
            }
            for (j = 0; j < i; ++j) {
                MethodDesc prev = this.descs[j];
                pname = prev.name;
                int plen = pname.length() - 1;
                if (pname.charAt(0) == '*') {
                    if (!dname.regionMatches(dname.length() - plen, pname, 1, plen)) continue;
                    BasicMethodConstraints.check(prev, desc);
                    continue;
                }
                if (pname.charAt(plen) == '*') {
                    if (!dname.regionMatches(0, pname, 0, plen)) continue;
                    BasicMethodConstraints.check(prev, desc);
                    continue;
                }
                if (!pname.equals(dname)) continue;
                BasicMethodConstraints.check(prev, desc);
            }
        }
    }

    private static void check(MethodDesc prev, MethodDesc desc) {
        if (prev.types == null || Arrays.equals(prev.types, desc.types)) {
            StringBuffer buf = new StringBuffer();
            prev.toString(buf, false);
            buf.append(" cannot precede ");
            desc.toString(buf, false);
            throw new IllegalArgumentException(buf.toString());
        }
    }

    public BasicMethodConstraints(InvocationConstraints constraints) {
        this.descs = new MethodDesc[]{new MethodDesc(constraints)};
    }

    public InvocationConstraints getConstraints(Method method) {
        String name = method.getName();
        Class<?>[] types = null;
        InvocationConstraints sc = null;
        block0: for (int i = 0; i < this.descs.length; ++i) {
            MethodDesc desc = this.descs[i];
            String dname = desc.name;
            if (dname == null) {
                sc = desc.constraints;
                break;
            }
            if (desc.types != null) {
                if (!name.equals(dname)) continue;
                if (types == null) {
                    types = method.getParameterTypes();
                }
                if (types.length != desc.types.length) continue;
                int j = types.length;
                while (--j >= 0) {
                    if (types[j] == desc.types[j]) continue;
                    continue block0;
                }
                sc = desc.constraints;
                break;
            }
            int dlen = dname.length() - 1;
            if (dname.charAt(0) == '*') {
                if (!name.regionMatches(name.length() - dlen, dname, 1, dlen)) continue;
                sc = desc.constraints;
                break;
            }
            if (dname.charAt(dlen) == '*') {
                if (!name.regionMatches(0, dname, 0, dlen)) continue;
                sc = desc.constraints;
                break;
            }
            if (!name.equals(dname)) continue;
            sc = desc.constraints;
            break;
        }
        if (sc == null) {
            sc = InvocationConstraints.EMPTY;
        }
        return sc;
    }

    public Iterator possibleConstraints() {
        return new Iterator(){
            private int i;
            private boolean empty;
            {
                this.i = BasicMethodConstraints.this.descs.length;
                this.empty = ((BasicMethodConstraints)BasicMethodConstraints.this).descs[this.i - 1].name != null;
            }

            public boolean hasNext() {
                return this.i > 0 || this.empty;
            }

            public Object next() {
                if (this.i == 0) {
                    if (this.empty) {
                        this.empty = false;
                        return InvocationConstraints.EMPTY;
                    }
                    throw new NoSuchElementException("no more elements");
                }
                InvocationConstraints sc = ((BasicMethodConstraints)BasicMethodConstraints.this).descs[--this.i].constraints;
                if (sc == null) {
                    sc = InvocationConstraints.EMPTY;
                }
                return sc;
            }

            public void remove() {
                throw new UnsupportedOperationException("immutable object");
            }
        };
    }

    public MethodDesc[] getMethodDescs() {
        return (MethodDesc[])this.descs.clone();
    }

    public int hashCode() {
        return BasicMethodConstraints.hash(this.descs);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("BasicMethodConstraints{");
        for (int i = 0; i < this.descs.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            this.descs[i].toString(buf, true);
        }
        buf.append('}');
        return buf.toString();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof BasicMethodConstraints && Arrays.equals(this.descs, ((BasicMethodConstraints)obj).descs);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.check();
        }
        catch (RuntimeException e) {
            BasicMethodConstraints.rethrow(e);
        }
    }

    private static int hash(Object[] elements) {
        int h = 0;
        int i = elements.length;
        while (--i >= 0) {
            h += elements[i].hashCode();
        }
        return h;
    }

    private static void rethrow(RuntimeException e) throws InvalidObjectException {
        if (e instanceof NullPointerException || e instanceof IllegalArgumentException) {
            InvalidObjectException ee = new InvalidObjectException(e.getMessage());
            ee.initCause(e);
            throw ee;
        }
        throw e;
    }

    public static final class MethodDesc
    implements Serializable {
        private static final long serialVersionUID = 6773269226844208999L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = BasicMethodConstraints.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("types", array$Ljava$lang$Class == null ? (array$Ljava$lang$Class = BasicMethodConstraints.class$("[Ljava.lang.Class;")) : array$Ljava$lang$Class, true), new ObjectStreamField("constraints", class$net$jini$core$constraint$InvocationConstraints == null ? (class$net$jini$core$constraint$InvocationConstraints = BasicMethodConstraints.class$("net.jini.core.constraint.InvocationConstraints")) : class$net$jini$core$constraint$InvocationConstraints)};
        final String name;
        final Class[] types;
        final InvocationConstraints constraints;

        public MethodDesc(String name, Class[] types, InvocationConstraints constraints) {
            this.name = name;
            this.types = (Class[])types.clone();
            if (constraints != null && constraints.isEmpty()) {
                constraints = null;
            }
            this.constraints = constraints;
            this.check();
        }

        public MethodDesc(String name, InvocationConstraints constraints) {
            this.name = name;
            this.types = null;
            if (constraints != null && constraints.isEmpty()) {
                constraints = null;
            }
            this.constraints = constraints;
            this.check();
        }

        private void check() {
            boolean star = this.types == null;
            int len = this.name.length();
            if (len == 0) {
                throw new IllegalArgumentException("method name cannot be empty");
            }
            char c = this.name.charAt(0);
            if (!(Character.isJavaIdentifierStart(c) || star && c == '*' && len > 1)) {
                throw new IllegalArgumentException("invalid method name");
            }
            if (star && c != '*' && this.name.charAt(len - 1) == '*') {
                --len;
            }
            while (--len >= 1) {
                if (Character.isJavaIdentifierPart(this.name.charAt(len))) continue;
                throw new IllegalArgumentException("invalid method name");
            }
            if (this.types != null) {
                int i = this.types.length;
                while (--i >= 0) {
                    if (this.types[i] != null) continue;
                    throw new NullPointerException("class cannot be null");
                }
            }
        }

        public MethodDesc(InvocationConstraints constraints) {
            this.name = null;
            this.types = null;
            if (constraints != null && constraints.isEmpty()) {
                constraints = null;
            }
            this.constraints = constraints;
        }

        public String getName() {
            return this.name;
        }

        public Class[] getParameterTypes() {
            return this.types == null ? null : (Class[])this.types.clone();
        }

        public InvocationConstraints getConstraints() {
            return this.constraints == null ? InvocationConstraints.EMPTY : this.constraints;
        }

        public int hashCode() {
            int h = 0;
            if (this.name != null) {
                h += this.name.hashCode();
            }
            if (this.types != null) {
                h += BasicMethodConstraints.hash(this.types);
            }
            if (this.constraints != null) {
                h += this.constraints.hashCode();
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MethodDesc)) {
                return false;
            }
            MethodDesc od = (MethodDesc)obj;
            return (this.name == null ? od.name == null : this.name.equals(od.name)) && Arrays.equals(this.types, od.types) && (this.constraints == null ? od.constraints == null : this.constraints.equals(od.constraints));
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("MethodDesc[");
            this.toString(buf, true);
            buf.append(']');
            return buf.toString();
        }

        void toString(StringBuffer buf, boolean includeConstraints) {
            buf.append(this.name == null ? "default" : this.name);
            if (this.types != null) {
                buf.append('(');
                for (int i = 0; i < this.types.length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(this.types[i].getName());
                }
                buf.append(')');
            }
            if (includeConstraints) {
                buf.append(" => ").append(this.constraints);
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (this.name == null) {
                if (this.types != null) {
                    throw new InvalidObjectException("cannot have types with null name");
                }
            } else {
                try {
                    this.check();
                }
                catch (RuntimeException e) {
                    BasicMethodConstraints.rethrow(e);
                }
            }
            if (this.constraints != null && this.constraints.isEmpty()) {
                throw new InvalidObjectException("constraints cannot be empty");
            }
        }
    }
}

