/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import com.sun.jini.action.GetBooleanAction;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.jeri.internal.runtime.WeakKey;
import com.sun.jini.logging.Levels;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.ExportException;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.io.MarshalInputStream;
import net.jini.io.MarshalOutputStream;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.ServerCapabilities;
import net.jini.security.proxytrust.ProxyTrust;
import net.jini.security.proxytrust.ServerProxyTrust;

public class BasicInvocationDispatcher
implements InvocationDispatcher {
    static final byte VERSION = 0;
    static final byte MISMATCH = 0;
    static final byte RETURN = 1;
    static final byte THROW = 2;
    private final ClassLoader loader;
    private final MethodConstraints serverConstraints;
    private final Constructor permConstructor;
    private final boolean permUsesMethod;
    private final Map permissions;
    private final Map methods;
    private static final Map domains = new HashMap();
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static final Logger logger = Logger.getLogger("net.jini.jeri.BasicInvocationDispatcher");
    private static final boolean suppressStackTraces = (Boolean)AccessController.doPrivileged(new GetBooleanAction("com.sun.jini.jeri.server.suppressStackTraces"));
    private static final CodeSource emptyCS = new CodeSource(null, (Certificate[])null);
    private static final ProtectionDomain emptyPD = new ProtectionDomain(emptyCS, null, null, null);
    private static final Permission getClassLoaderPermission = new RuntimePermission("getClassLoader");

    public BasicInvocationDispatcher(Collection methods, ServerCapabilities serverCapabilities, MethodConstraints serverConstraints, Class permissionClass, ClassLoader loader) throws ExportException {
        if (serverCapabilities == null) {
            throw new NullPointerException();
        }
        this.methods = new HashMap();
        this.loader = loader;
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Object m = iter.next();
            if (m == null) {
                throw new NullPointerException("methods contains null");
            }
            if (!(m instanceof Method)) {
                throw new IllegalArgumentException("methods must contain only Methods");
            }
            this.methods.put(new Long(Util.getMethodHash((Method)m)), m);
        }
        this.serverConstraints = serverConstraints;
        if (permissionClass != null) {
            Util.checkPackageAccess(permissionClass);
        }
        this.permConstructor = BasicInvocationDispatcher.getConstructor(permissionClass);
        this.permUsesMethod = this.permConstructor != null && this.permConstructor.getParameterTypes()[0] == Method.class;
        this.permissions = this.permConstructor == null ? null : new IdentityHashMap(methods.size() + 2);
        try {
            if (serverConstraints == null) {
                BasicInvocationDispatcher.checkConstraints(serverCapabilities, InvocationConstraints.EMPTY);
            } else {
                iter = serverConstraints.possibleConstraints();
                while (iter.hasNext()) {
                    BasicInvocationDispatcher.checkConstraints(serverCapabilities, (InvocationConstraints)iter.next());
                }
            }
        }
        catch (UnsupportedConstraintException e) {
            throw new ExportException("server does not support some constraints", e);
        }
    }

    private static void checkConstraints(ServerCapabilities serverCapabilities, InvocationConstraints constraints) throws UnsupportedConstraintException {
        InvocationConstraints unfulfilled = serverCapabilities.checkConstraints(constraints);
        Iterator i = unfulfilled.requirements().iterator();
        while (i.hasNext()) {
            InvocationConstraint c = (InvocationConstraint)i.next();
            if (c instanceof Integrity) continue;
            throw new UnsupportedConstraintException("cannot satisfy unfulfilled constraint: " + c);
        }
    }

    protected final ClassLoader getClassLoader() {
        return this.loader;
    }

    public static void checkPermissionClass(Class permissionClass) {
        BasicInvocationDispatcher.getConstructor(permissionClass);
    }

    private static Constructor getConstructor(Class permissionClass) {
        Constructor permConstructor;
        if (permissionClass == null) {
            return null;
        }
        int mods = permissionClass.getModifiers();
        if (!Permission.class.isAssignableFrom(permissionClass) || Modifier.isAbstract(mods) || !Modifier.isPublic(mods)) {
            throw new IllegalArgumentException("bad permission class");
        }
        try {
            permConstructor = permissionClass.getConstructor(Method.class);
            if (permConstructor.getExceptionTypes().length == 0) {
                return permConstructor;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            permConstructor = permissionClass.getConstructor(String.class);
            if (permConstructor.getExceptionTypes().length == 0) {
                return permConstructor;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new IllegalArgumentException("bad permission class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatch(Remote impl, InboundRequest request, Collection context) {
        block44: {
            if (impl == null) throw new NullPointerException();
            if (context == null) {
                throw new NullPointerException();
            }
            rin = null;
            try {
                rin = request.getRequestInputStream();
                switch (rin.read()) {
                    case 0: {
                        break;
                    }
                    case -1: {
                        throw new EOFException();
                    }
                    default: {
                        rin.close();
                        ros = request.getResponseOutputStream();
                        ros.write(0);
                        ros.write(0);
                        ros.close();
                        return;
                    }
                }
                switch (rin.read()) {
                    case 0: {
                        integrity = false;
                        break;
                    }
                    case -1: {
                        throw new EOFException();
                    }
                    default: {
                        integrity = true;
                        break;
                    }
                }
            }
            catch (Throwable t) {
                if (BasicInvocationDispatcher.logger.isLoggable(Levels.FAILED)) {
                    this.logThrow(impl, t);
                }
                request.abort();
                return;
            }
            method = null;
            returnValue = null;
            t /* !! */  = null;
            fromImpl = false;
            Util.populateContext(context, integrity);
            in = null;
            try {
                try {
                    in = this.createMarshalInputStream(impl, request, integrity, context);
                    method = this.unmarshalMethod(impl, in, context);
                    v0 = sc = this.serverConstraints == null ? InvocationConstraints.EMPTY : this.serverConstraints.getConstraints(method);
                    if (integrity && !sc.requirements().contains(Integrity.YES)) {
                        requirements = new ArrayList<Integrity>(sc.requirements());
                        requirements.add(Integrity.YES);
                        sc = new InvocationConstraints(requirements, sc.preferences());
                    }
                    unfulfilled = request.checkConstraints(sc);
                    i = unfulfilled.requirements().iterator();
                    while (i.hasNext()) {
                        c = (InvocationConstraint)i.next();
                        if (c instanceof Integrity == false) throw new UnsupportedConstraintException("cannot satisfy unfulfilled constraint: " + c);
                        if (integrity || c != Integrity.YES) continue;
                        throw new UnsupportedConstraintException("cannot satisfy unfulfilled constraint: " + c);
                    }
                    this.checkAccess(impl, method, sc, context);
                    args = this.unmarshalArguments(impl, method, in, context);
                    if (BasicInvocationDispatcher.logger.isLoggable(Level.FINE)) {
                        this.logCall(impl, method, args);
                    }
                    try {
                        returnValue = this.invoke(impl, method, args, context);
                        if (BasicInvocationDispatcher.logger.isLoggable(Level.FINE)) {
                            this.logReturn(impl, method, returnValue);
                        }
                    }
                    catch (Throwable tt) {
                        t /* !! */  = tt;
                        fromImpl = true;
                    }
                    var16_23 = null;
                    if (in == null) break block44;
                }
                catch (RuntimeException e) {
                    t /* !! */  = e;
                    var16_24 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignore) {}
                    }
                    break block44;
                }
                catch (Exception e) {
                    t /* !! */  = new UnmarshalException("unmarshalling method/arguments", e);
                    var16_25 = null;
                    if (in != null) {
                        try {}
                        catch (IOException ignore) {}
                        in.close();
                    }
                    break block44;
                }
                catch (Throwable tt) {
                    t /* !! */  = tt;
                    var16_26 = null;
                    if (in != null) {
                        try {}
                        catch (IOException ignore) {}
                        in.close();
                    }
                    break block44;
                }
            }
            catch (Throwable var15_33) {
                var16_27 = null;
                if (in == null) throw var15_33;
                ** try [egrp 4[TRYBLOCK] [11 : 560->568)] { 
lbl108:
                // 1 sources

                in.close();
                throw var15_33;
lbl110:
                // 1 sources

                catch (IOException ignore) {
                    // empty catch block
                }
                throw var15_33;
            }
            try {}
            catch (IOException ignore) {}
            in.close();
        }
        try {
            request.getResponseOutputStream().write(t /* !! */  == null ? 1 : 2);
            out = this.createMarshalOutputStream(impl, method, request, context);
            if (t /* !! */  != null) {
                if (BasicInvocationDispatcher.logger.isLoggable(Levels.FAILED)) {
                    this.logThrow(impl, method, t /* !! */ , fromImpl);
                }
                if (t /* !! */  instanceof RemoteException) {
                    t /* !! */  = new ServerException("RemoteException in server thread", t /* !! */ );
                } else if (t /* !! */  instanceof Error) {
                    t /* !! */  = new ServerError("Error in server thread", (Error)t /* !! */ );
                }
                if (BasicInvocationDispatcher.suppressStackTraces) {
                    Util.clearStackTraces(t /* !! */ );
                }
                this.marshalThrow(impl, method, t /* !! */ , out, context);
            } else {
                this.marshalReturn(impl, method, returnValue, out, context);
            }
            out.close();
            return;
        }
        catch (Throwable tt) {
            try {
                request.getResponseOutputStream().close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            request.abort();
            if (BasicInvocationDispatcher.logger.isLoggable(Levels.FAILED) == false) return;
            this.logThrow(impl, tt);
        }
    }

    protected ObjectInputStream createMarshalInputStream(Object impl, InboundRequest request, boolean integrity, Collection context) throws IOException {
        ClassLoader streamLoader;
        if (this.loader != null) {
            streamLoader = this.getClassLoader();
        } else {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(getClassLoaderPermission);
            }
            streamLoader = impl.getClass().getClassLoader();
        }
        Collection unmodContext = Collections.unmodifiableCollection(context);
        MarshalInputStream in = new MarshalInputStream(request.getRequestInputStream(), streamLoader, integrity, streamLoader, unmodContext);
        in.useCodebaseAnnotations();
        return in;
    }

    protected ObjectOutputStream createMarshalOutputStream(Object impl, Method method, InboundRequest request, Collection context) throws IOException {
        if (impl == null) {
            throw new NullPointerException();
        }
        OutputStream out = request.getResponseOutputStream();
        Collection unmodContext = Collections.unmodifiableCollection(context);
        return new MarshalOutputStream(out, unmodContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAccess(Remote impl, Method method, InvocationConstraints constraints, Collection context) {
        Permission perm;
        if (impl == null || method == null || context == null) {
            throw new NullPointerException();
        }
        if (this.permConstructor == null) {
            return;
        }
        Map map = this.permissions;
        synchronized (map) {
            perm = (Permission)this.permissions.get(method);
        }
        if (perm == null) {
            try {
                perm = (Permission)this.permConstructor.newInstance(this.permUsesMethod ? method : method.getDeclaringClass().getName() + "." + method.getName());
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw (RuntimeException)t;
            }
            catch (Exception e) {
                throw new RuntimeException("unexpected exception", e);
            }
            map = this.permissions;
            synchronized (map) {
                this.permissions.put(method, perm);
            }
        }
        BasicInvocationDispatcher.checkClientPermission(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void checkClientPermission(Permission permission) {
        void var2_2;
        ProtectionDomain pd;
        if (permission == null) {
            throw new NullPointerException();
        }
        Subject client = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Util.getClientSubject();
                }
                catch (ServerNotActiveException e) {
                    throw new IllegalStateException("server not active");
                }
            }
        });
        if (System.getSecurityManager() == null) {
            return;
        }
        if (client == null) {
            pd = emptyPD;
        } else {
            Map map = domains;
            synchronized (map) {
                WeakKey k;
                while ((k = (WeakKey)queue.poll()) != null) {
                    domains.remove(k);
                }
                pd = (ProtectionDomain)domains.get(new WeakKey(client));
                if (pd == null) {
                    Set<Principal> set = client.getPrincipals();
                    Principal[] prins = set.toArray(new Principal[set.size()]);
                    pd = new ProtectionDomain(emptyCS, null, null, prins);
                    domains.put(new WeakKey(client, queue), pd);
                }
            }
        }
        boolean ok = var2_2.implies(permission);
        if (!ok) {
            throw new AccessControlException("access denied " + permission);
        }
    }

    protected Method unmarshalMethod(Remote impl, ObjectInputStream in, Collection context) throws IOException, NoSuchMethodException, ClassNotFoundException {
        if (impl == null || context == null) {
            throw new NullPointerException();
        }
        long hash = in.readLong();
        Method method = (Method)this.methods.get(new Long(hash));
        if (method == null) {
            throw new NoSuchMethodException("unrecognized method hash: method not supported by remote object");
        }
        return method;
    }

    protected Object[] unmarshalArguments(Remote impl, Method method, ObjectInputStream in, Collection context) throws IOException, ClassNotFoundException {
        if (impl == null || in == null || context == null) {
            throw new NullPointerException();
        }
        Class<?>[] types = method.getParameterTypes();
        Object[] args = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            args[i] = Util.unmarshalValue(types[i], in);
        }
        return args;
    }

    protected Object invoke(Remote impl, Method method, Object[] args, Collection context) throws Throwable {
        if (impl == null || args == null || context == null) {
            throw new NullPointerException();
        }
        if (!(method.isAccessible() || Modifier.isPublic(method.getDeclaringClass().getModifiers()) && Modifier.isPublic(method.getModifiers()))) {
            throw new IllegalArgumentException("method not public or set accessible");
        }
        Class<?> decl = method.getDeclaringClass();
        if (decl == ProxyTrust.class && method.getName().equals("getProxyVerifier") && impl instanceof ServerProxyTrust) {
            if (args.length != 0) {
                throw new IllegalArgumentException("incorrect arguments");
            }
            return ((ServerProxyTrust)((Object)impl)).getProxyVerifier();
        }
        try {
            return method.invoke((Object)impl, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected void marshalReturn(Remote impl, Method method, Object returnValue, ObjectOutputStream out, Collection context) throws IOException {
        if (impl == null || out == null || context == null) {
            throw new NullPointerException();
        }
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE) {
            Util.marshalValue(returnType, returnValue, out);
        }
    }

    protected void marshalThrow(Remote impl, Method method, Throwable throwable, ObjectOutputStream out, Collection context) throws IOException {
        if (impl == null || throwable == null || context == null) {
            throw new NullPointerException();
        }
        out.writeObject(throwable);
    }

    private void logCall(Remote impl, Method method, Object[] args) {
        Subject client;
        String msg = "inbound call {0}.{1} to {2} from {3}\nclient {4}";
        if (logger.isLoggable(Level.FINEST)) {
            msg = "inbound call {0}.{1} to {2} from {3}\nargs {5}\nclient {4}";
        }
        Set<Principal> prins = (client = BasicInvocationDispatcher.getClientSubject()) != null ? client.getPrincipals() : null;
        String host = null;
        try {
            host = Util.getClientHostString();
        }
        catch (ServerNotActiveException e) {
            // empty catch block
        }
        logger.log(Level.FINE, msg, new Object[]{method.getDeclaringClass().getName(), method.getName(), impl, host, prins, Arrays.asList(args)});
    }

    private void logReturn(Remote impl, Method method, Object res) {
        String msg = "inbound call {0}.{1} to {2} returns";
        if (logger.isLoggable(Level.FINEST) && method.getReturnType() != Void.TYPE) {
            msg = "inbound call {0}.{1} to {2} returns {3}";
        }
        logger.logp(Level.FINE, this.getClass().getName(), "dispatch", msg, new Object[]{method.getDeclaringClass().getName(), method.getName(), impl, res});
    }

    private void logThrow(Remote impl, Method method, Throwable t, boolean fromImpl) {
        LogRecord lr = new LogRecord(Levels.FAILED, fromImpl ? "inbound call {0}.{1} to {2} remotely throws" : (logger.isLoggable(Level.FINEST) ? "inbound call {0}.{1} to {2} dispatch remotely throws\nclient {3}" : "inbound call {0}.{1} to {2} dispatch remotely throws"));
        lr.setLoggerName(logger.getName());
        lr.setSourceClassName(this.getClass().getName());
        lr.setSourceMethodName("dispatch");
        lr.setParameters(new Object[]{method == null ? "<unknown>" : method.getDeclaringClass().getName(), method == null ? "<unknown>" : method.getName(), impl, BasicInvocationDispatcher.getClientSubject()});
        lr.setThrown(t);
        logger.log(lr);
    }

    private void logThrow(Remote impl, Throwable t) {
        LogRecord lr = new LogRecord(Levels.FAILED, logger.isLoggable(Level.FINEST) ? "{0} locally throws\nclient {1}" : "{0} locally throws");
        lr.setLoggerName(logger.getName());
        lr.setSourceClassName(this.getClass().getName());
        lr.setSourceMethodName("dispatch");
        lr.setParameters(new Object[]{impl, BasicInvocationDispatcher.getClientSubject()});
        lr.setThrown(t);
        logger.log(lr);
    }

    private static Subject getClientSubject() {
        return (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Util.getClientSubject();
                }
                catch (ServerNotActiveException e) {
                    return null;
                }
            }
        });
    }
}

