/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.internal.SslEndpointInternalsAccess;
import com.sun.jini.jeri.internal.connection.ConnManagerFactory;
import com.sun.jini.jeri.internal.connection.ServerConnManager;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.ssl.CallContext;
import net.jini.jeri.ssl.SslEndpointImpl;
import net.jini.jeri.ssl.SslServerEndpoint;
import net.jini.jeri.ssl.SslServerEndpointImpl;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.Security;
import net.jini.security.proxytrust.TrustEquivalence;

public final class SslEndpoint
implements Endpoint,
Serializable,
TrustEquivalence {
    private static final long serialVersionUID = 5311538504705775156L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("serverHost", String.class), new ObjectStreamField("port", Integer.TYPE), new ObjectStreamField("socketFactory", SocketFactory.class)};
    transient SslEndpointImpl impl;

    public static SslEndpoint getInstance(String serverHost, int port) {
        return new SslEndpoint(serverHost, port, null);
    }

    public static SslEndpoint getInstance(String serverHost, int port, SocketFactory socketFactory) {
        return new SslEndpoint(serverHost, port, socketFactory);
    }

    private SslEndpoint(String serverHost, int port, SocketFactory socketFactory) {
        this.impl = new SslEndpointImpl(this, serverHost, port, socketFactory);
    }

    public String getHost() {
        return this.impl.serverHost;
    }

    public int getPort() {
        return this.impl.port;
    }

    public SocketFactory getSocketFactory() {
        return this.impl.socketFactory;
    }

    public String toString() {
        return "SslEndpoint" + this.impl.fieldsToString();
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof SslEndpoint && this.impl.equals(((SslEndpoint)object).impl);
    }

    public OutboundRequestIterator newRequest(InvocationConstraints constraints) {
        return this.impl.newRequest(constraints);
    }

    public boolean checkTrustEquivalence(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof SslEndpoint && this.impl.equals(((SslEndpoint)obj).impl);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("serverHost", this.impl.serverHost);
        fields.put("port", this.impl.port);
        fields.put("socketFactory", this.impl.socketFactory);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        String serverHost = (String)fields.get("serverHost", null);
        int port = fields.get("port", 0);
        SocketFactory socketFactory = (SocketFactory)fields.get("socketFactory", null);
        if (serverHost == null) {
            throw new InvalidObjectException("serverHost cannot be null");
        }
        if (port <= 0 || port > 65535) {
            throw new InvalidObjectException("Invalid port: " + port);
        }
        this.impl = new SslEndpointImpl(this, serverHost, port, socketFactory);
    }

    static {
        SslEndpointInternals.registerDiscoveryBackDoor();
    }

    private static final class SslEndpointInternals
    extends Utilities
    implements EndpointInternals {
        private SslEndpointInternals() {
        }

        static void registerDiscoveryBackDoor() {
            SslEndpointInternals backDoor = new SslEndpointInternals();
            try {
                Security.doPrivileged(new PrivilegedAction(backDoor){
                    private final /* synthetic */ SslEndpointInternals val$backDoor;
                    {
                        this.val$backDoor = val$backDoor;
                    }

                    public Object run() {
                        SslEndpointInternalsAccess.set(this.val$backDoor);
                        return null;
                    }
                });
            }
            catch (RuntimeException e) {
                initLogger.log(Level.WARNING, "Problem registering with discovery provider", e);
            }
            catch (Error e) {
                initLogger.log(Level.WARNING, "Problem registering with discovery provider", e);
            }
        }

        public void disableSocketConnect(Endpoint endpoint) {
            SslEndpointInternals.coerce((Endpoint)endpoint).disableSocketConnect = true;
        }

        private static SslEndpointImpl coerce(Endpoint endpoint) {
            if (!(endpoint instanceof SslEndpoint)) {
                throw new IllegalArgumentException("Endpoint must be an SslEndpoint: " + endpoint);
            }
            return ((SslEndpoint)endpoint).impl;
        }

        private static SslServerEndpointImpl coerce(ServerEndpoint endpoint) {
            if (!(endpoint instanceof SslServerEndpoint)) {
                throw new IllegalArgumentException("Server endpoint must be an SslServerEndpoint: " + endpoint);
            }
            return ((SslServerEndpoint)endpoint).impl;
        }

        public void setConnManagerFactory(Endpoint endpoint, ConnManagerFactory factory) {
            SslEndpointImpl impl = SslEndpointInternals.coerce(endpoint);
            impl.connectionManager = factory.create(impl);
        }

        public void setServerConnManager(ServerEndpoint endpoint, ServerConnManager manager) {
            SslEndpointInternals.coerce((ServerEndpoint)endpoint).serverConnectionManager = manager;
        }

        public InvocationConstraints getUnfulfilledConstraints(OutboundRequestHandle handle) {
            return SslEndpointInternals.coerce(handle).getUnfulfilledConstraints();
        }

        private static CallContext coerce(OutboundRequestHandle handle) {
            if (!(handle instanceof CallContext)) {
                throw new IllegalArgumentException("Handle must be a CallContext: " + handle);
            }
            return (CallContext)handle;
        }
    }
}

