/*
 * Decompiled with CFR 0.152.
 */
package net.jini.loader.pref;

import com.sun.jini.action.GetPropertyAction;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.RMIClassLoaderSpi;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.loader.ClassAnnotation;
import net.jini.loader.pref.PreferredClassLoader;

public class PreferredClassProvider
extends RMIClassLoaderSpi {
    private static final String PRIMITIVE_TYPES = "BCDFIJSZ";
    private final boolean requireDlPerm;
    private final boolean initialized;
    private static final Logger logger;
    private static final Permission getClassLoaderPermission;
    private static String codebaseProperty;
    private static final Map localLoaders;
    private final Map loaderTable = new HashMap();
    private final ReferenceQueue refQueue = new ReferenceQueue();
    private final Map classLoaderPerms = new WeakHashMap();
    private static Map pathToURLsCache;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PreferredClassProvider() {
        this(false);
    }

    protected PreferredClassProvider(boolean requireDlPerm) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        this.requireDlPerm = requireDlPerm;
        this.initialized = true;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new SecurityException("uninitialized instance");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLoader(ClassLoader loader, ClassLoader parent, URL[] urls) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && loader != null && loader != parent) {
            if (!$assertionsDisabled && !this.urlsMatchLoaderAnnotation(urls, loader)) {
                throw new AssertionError();
            }
            if (loader.getClass() == PreferredClassLoader.class) {
                ((PreferredClassLoader)loader).checkPermissions();
            } else {
                Permissions perms;
                Map map = this.classLoaderPerms;
                synchronized (map) {
                    perms = (Permissions)this.classLoaderPerms.get(loader);
                    if (perms == null) {
                        perms = new Permissions();
                        PreferredClassLoader.addPermissionsForURLs(urls, perms, false);
                        this.classLoaderPerms.put(loader, perms);
                    }
                }
                Enumeration<Permission> en = perms.elements();
                while (en.hasMoreElements()) {
                    sm.checkPermission(en.nextElement());
                }
            }
        }
    }

    public Class loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        this.checkInitialized();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "name=\"{0}\", codebase={1}, defaultLoader={2}", new Object[]{name, codebase != null ? "\"" + codebase + "\"" : null, defaultLoader});
        }
        URL[] codebaseURLs = PreferredClassProvider.pathToURLs(codebase);
        String elementTypeName = null;
        int len = name.length();
        if (len > 0 && name.charAt(0) == '[') {
            int i;
            char c = '\u0000';
            for (i = 1; i < len && (c = name.charAt(i)) == '['; ++i) {
            }
            if (len == i + 1 && PRIMITIVE_TYPES.indexOf(c) != -1) {
                return Class.forName(name);
            }
            if (len > i + 2 && c == 'L' && name.charAt(len - 1) == ';') {
                elementTypeName = name.substring(i + 1, len - 1);
            }
        }
        SecurityManager sm = System.getSecurityManager();
        if (defaultLoader != null && (sm == null || codebaseURLs == null || this.urlsMatchLoaderAnnotation(codebaseURLs, defaultLoader))) {
            try {
                Class<?> c = Class.forName(name, false, defaultLoader);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "class \"{0}\" found via defaultLoader, defined by {1}", new Object[]{name, PreferredClassProvider.getClassLoader(c)});
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                defaultLoader = null;
            }
        }
        ClassLoader contextLoader = PreferredClassProvider.getRMIContextClassLoader();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "(thread context class loader: {0})", contextLoader);
        }
        ClassLoader codebaseLoader = this.lookupLoader(codebaseURLs, contextLoader);
        if (defaultLoader != null && !(codebaseLoader instanceof PreferredClassLoader)) {
            try {
                Class<?> c = Class.forName(name, false, defaultLoader);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "class \"{0}\" found via defaultLoader, defined by {1}", new Object[]{name, PreferredClassProvider.getClassLoader(c)});
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                defaultLoader = null;
            }
        }
        SecurityException secEx = null;
        if (sm != null) {
            try {
                this.checkLoader(codebaseLoader, contextLoader, codebaseURLs);
            }
            catch (SecurityException e) {
                secEx = e;
            }
        }
        if (defaultLoader != null) {
            boolean tryDL;
            boolean bl = tryDL = secEx != null;
            if (!tryDL) {
                try {
                    tryDL = !((PreferredClassLoader)codebaseLoader).isPreferredResource(elementTypeName != null ? elementTypeName : name, true);
                }
                catch (IOException e) {
                    ClassNotFoundException cnfe = new ClassNotFoundException(name + " (could not determine preferred setting;" + " original codebase: \"" + codebase + "\")", e);
                    if (logger.isLoggable(Levels.FAILED)) {
                        LogUtil.logThrow(logger, Levels.FAILED, PreferredClassProvider.class, "loadClass", "class \"{0}\" not found, could not obtain preferred value", new Object[]{name}, cnfe);
                    }
                    throw cnfe;
                }
            }
            if (tryDL) {
                try {
                    Class<?> c = Class.forName(name, false, defaultLoader);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "class \"{0}\" found via defaultLoader, defined by {1}", new Object[]{name, PreferredClassProvider.getClassLoader(c)});
                    }
                    return c;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        try {
            Class<?> c = Class.forName(name, false, sm != null && secEx == null ? codebaseLoader : contextLoader);
            if (logger.isLoggable(Level.FINEST)) {
                String message = sm == null ? "class \"{0}\" found  via thread context class loader  (no security manager), defined by {1}" : (secEx != null ? "class \"{0}\" found  via thread context class loader  (access to codebase loader denied), defined by {1}" : "class \"{0}\" found via codebase loader, defined by {1}");
                logger.log(Level.FINEST, message, new Object[]{name, PreferredClassProvider.getClassLoader(c)});
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            if (sm == null) {
                ClassNotFoundException cnfe = new ClassNotFoundException(e.getMessage() + " (no security manager: codebase loader disabled)", e);
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, PreferredClassProvider.class, "loadClass", "class \"{0}\" not found via thread context class loader (no security manager)", new Object[]{name}, cnfe);
                }
                throw cnfe;
            }
            if (secEx != null) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    LogUtil.logThrow(logger, Levels.HANDLED, PreferredClassProvider.class, "loadClass", "class \"{0}\" not found via thread context class loader (access to codebase loader denied)", new Object[]{name}, e);
                }
                ClassNotFoundException cnfe = new ClassNotFoundException(e.getMessage() + " (access to codebase loader denied)", secEx);
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, PreferredClassProvider.class, "loadClass", "class \"{0}\" not found via thread context class loader (access to codebase loader denied)", new Object[]{name}, cnfe);
                }
                throw cnfe;
            }
            if (logger.isLoggable(Levels.FAILED)) {
                LogUtil.logThrow(logger, Levels.FAILED, PreferredClassProvider.class, "loadClass", "class \"{0}\" not found via codebase loader", new Object[]{name}, e);
            }
            throw e;
        }
    }

    public String getClassAnnotation(Class cl) {
        this.checkInitialized();
        String name = cl.getName();
        int nameLength = name.length();
        if (nameLength > 0 && name.charAt(0) == '[') {
            int i;
            for (i = 1; nameLength > i && name.charAt(i) == '['; ++i) {
            }
            if (nameLength > i && name.charAt(i) != 'L') {
                return null;
            }
        }
        return this.getLoaderAnnotation(PreferredClassProvider.getClassLoader(cl), true);
    }

    protected String getClassAnnotation(ClassLoader loader) {
        this.checkInitialized();
        return codebaseProperty;
    }

    private String getLoaderAnnotation(ClassLoader loader, boolean check) {
        if (PreferredClassProvider.isLocalLoader(loader)) {
            return this.getClassAnnotation(loader);
        }
        String annotation = null;
        if (loader instanceof ClassAnnotation) {
            annotation = ((ClassAnnotation)((Object)loader)).getClassAnnotation();
        } else if (loader instanceof URLClassLoader) {
            try {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                if (urls != null) {
                    SecurityManager sm;
                    if (check && (sm = System.getSecurityManager()) != null) {
                        Permissions perms = new Permissions();
                        for (int i = 0; i < urls.length; ++i) {
                            Permission p = urls[i].openConnection().getPermission();
                            if (p == null || perms.implies(p)) continue;
                            sm.checkPermission(p);
                            perms.add(p);
                        }
                    }
                    annotation = PreferredClassLoader.urlsToPath(urls);
                }
            }
            catch (SecurityException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (annotation != null) {
            return annotation;
        }
        return this.getClassAnnotation(loader);
    }

    private static boolean isLocalLoader(ClassLoader loader) {
        return loader == null || localLoaders.containsKey(loader);
    }

    public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
        this.checkInitialized();
        URL[] codebaseURLs = PreferredClassProvider.pathToURLs(codebase);
        ClassLoader contextLoader = PreferredClassProvider.getRMIContextClassLoader();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return contextLoader;
        }
        sm.checkPermission(getClassLoaderPermission);
        ClassLoader codebaseLoader = this.lookupLoader(codebaseURLs, contextLoader);
        this.checkLoader(codebaseLoader, contextLoader, codebaseURLs);
        return codebaseLoader;
    }

    public Class loadProxyClass(String codebase, String[] interfaceNames, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        String loaderName;
        ClassLoader loader;
        this.checkInitialized();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "interfaces={0}, codebase={1}, defaultLoader={2}", new Object[]{Arrays.asList(interfaceNames), codebase != null ? "\"" + codebase + "\"" : null, defaultLoader});
        }
        URL[] codebaseURLs = PreferredClassProvider.pathToURLs(codebase);
        ClassLoader contextLoader = PreferredClassProvider.getRMIContextClassLoader();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "(thread context class loader: {0})", contextLoader);
        }
        ClassLoader codebaseLoader = this.lookupLoader(codebaseURLs, contextLoader);
        SecurityManager sm = System.getSecurityManager();
        SecurityException secEx = null;
        if (sm != null) {
            try {
                this.checkLoader(codebaseLoader, contextLoader, codebaseURLs);
            }
            catch (SecurityException e) {
                secEx = e;
            }
        }
        if (defaultLoader != null) {
            boolean tryDL;
            boolean codebaseMatchesDL = false;
            boolean bl = tryDL = sm == null || secEx != null || codebaseURLs == null;
            if (!tryDL) {
                codebaseMatchesDL = this.urlsMatchLoaderAnnotation(codebaseURLs, defaultLoader);
                boolean bl2 = tryDL = codebaseMatchesDL || !(codebaseLoader instanceof PreferredClassLoader) || !this.interfacePreferred((PreferredClassLoader)codebaseLoader, interfaceNames, codebase);
            }
            if (tryDL) {
                try {
                    boolean preferCodebaseLoader = sm != null && secEx == null && !codebaseMatchesDL;
                    Class c = this.loadProxyClass(interfaceNames, defaultLoader, "defaultLoader", codebaseLoader, preferCodebaseLoader);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, PreferredClassProvider.getProxySuccessLogMessage(sm, secEx), PreferredClassProvider.getClassLoader(c));
                    }
                    return c;
                }
                catch (ClassNotFoundException e) {
                }
                catch (IllegalArgumentException e) {
                    ClassNotFoundException cnfe = new ClassNotFoundException("dynamic proxy class creation failed", e);
                    if (logger.isLoggable(Levels.FAILED)) {
                        logger.log(Levels.FAILED, "dynamic proxy class creation failed", e);
                    }
                    throw cnfe;
                }
            }
        }
        if (sm != null && secEx == null) {
            loader = codebaseLoader;
            loaderName = "codebase loader";
        } else {
            loader = contextLoader;
            loaderName = "thread context class loader";
        }
        try {
            Class c = this.loadProxyClass(interfaceNames, loader, loaderName, null, false);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, PreferredClassProvider.getProxySuccessLogMessage(sm, secEx), PreferredClassProvider.getClassLoader(c));
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            if (sm == null) {
                ClassNotFoundException cnfe = new ClassNotFoundException(e.getMessage() + " (no security manager: codebase loader disabled)", e);
                if (logger.isLoggable(Levels.FAILED)) {
                    logger.log(Levels.FAILED, "proxy class resolution failed (no security manager)", cnfe);
                }
                throw cnfe;
            }
            if (secEx != null) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    logger.log(Levels.HANDLED, "proxy class resolution failed (access to codebase loader denied)", e);
                }
                ClassNotFoundException cnfe = new ClassNotFoundException(e.getMessage() + " (access to codebase loader denied)", secEx);
                if (logger.isLoggable(Levels.FAILED)) {
                    logger.log(Levels.FAILED, "proxy class resolution failed (access to codebase loader denied)", cnfe);
                }
                throw cnfe;
            }
            if (logger.isLoggable(Levels.FAILED)) {
                logger.log(Levels.FAILED, "proxy class resolution failed", e);
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            ClassNotFoundException cnfe = new ClassNotFoundException("dynamic proxy class creation failed", e);
            if (logger.isLoggable(Levels.FAILED)) {
                logger.log(Levels.FAILED, "dynamic proxy class creation failed", e);
            }
            throw cnfe;
        }
    }

    private static String getProxySuccessLogMessage(SecurityManager sm, SecurityException secEx) {
        if (sm == null) {
            return "(no security manager) proxy class defined by {0}";
        }
        if (secEx != null) {
            return "(access to codebase loader denied) proxy class defined by {0}";
        }
        return "proxy class defined by {0}";
    }

    private Class loadProxyClass(String[] interfaceNames, ClassLoader interfaceLoader, String interfaceLoaderName, ClassLoader otherLoader, boolean tryOtherLoaderFirst) throws ClassNotFoundException {
        Class[] classObjs = new Class[interfaceNames.length];
        boolean[] nonpublic = new boolean[]{false};
        ClassLoader proxyLoader = this.loadProxyInterfaces(interfaceNames, interfaceLoader, classObjs, nonpublic);
        if (logger.isLoggable(Level.FINEST)) {
            ClassLoader[] definingLoaders = new ClassLoader[classObjs.length];
            for (int i = 0; i < definingLoaders.length; ++i) {
                definingLoaders[i] = PreferredClassProvider.getClassLoader(classObjs[i]);
            }
            logger.log(Level.FINEST, "proxy interfaces loaded via {0}, defined by {1}", new Object[]{interfaceLoaderName, Arrays.asList(definingLoaders)});
        }
        if (!nonpublic[0]) {
            if (tryOtherLoaderFirst) {
                try {
                    return Proxy.getProxyClass(otherLoader, classObjs);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            proxyLoader = interfaceLoader;
        }
        return Proxy.getProxyClass(proxyLoader, classObjs);
    }

    private boolean interfacePreferred(PreferredClassLoader codebaseLoader, String[] interfaceNames, String codebase) throws ClassNotFoundException {
        for (int p = 0; p < interfaceNames.length; ++p) {
            try {
                if (!codebaseLoader.isPreferredResource(interfaceNames[p], true)) continue;
                return true;
            }
            catch (IOException e) {
                ClassNotFoundException cnfe = new ClassNotFoundException(interfaceNames[p] + " (could not determine preferred setting;" + " original codebase: \"" + codebase + "\")", e);
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, PreferredClassProvider.class, "loadProxyClass", "class \"{0}\" not found, could not obtain preferred value", new Object[]{interfaceNames[p]}, cnfe);
                }
                throw cnfe;
            }
        }
        return false;
    }

    private URL[] getLoaderAnnotationURLs(ClassLoader loader) throws MalformedURLException {
        return PreferredClassProvider.pathToURLs(this.getLoaderAnnotation(loader, false));
    }

    private boolean urlsMatchLoaderAnnotation(URL[] urls, ClassLoader loader) {
        try {
            return Arrays.equals(urls, this.getLoaderAnnotationURLs(loader));
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private ClassLoader loadProxyInterfaces(String[] interfaces, ClassLoader loader, Class[] classObjs, boolean[] useNonpublic) throws ClassNotFoundException {
        ClassLoader nonpublic = null;
        for (int i = 0; i < interfaces.length; ++i) {
            classObjs[i] = Class.forName(interfaces[i], false, loader);
            Class<?> cl = classObjs[i];
            if (Modifier.isPublic(cl.getModifiers())) continue;
            ClassLoader current = PreferredClassProvider.getClassLoader(cl);
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, (class$net$jini$loader$pref$PreferredClassProvider == null ? PreferredClassProvider.class$("net.jini.loader.pref.PreferredClassProvider") : class$net$jini$loader$pref$PreferredClassProvider).getName(), "loadProxyClass", "non-public interface \"{0}\" defined by {1}", new Object[]{interfaces[i], current});
            }
            if (!useNonpublic[0]) {
                nonpublic = current;
                useNonpublic[0] = true;
                continue;
            }
            if (current == nonpublic) continue;
            throw new IllegalAccessError("non-public interfaces defined in different class loaders");
        }
        return nonpublic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL[] pathToURLs(String path) throws MalformedURLException {
        if (path == null) {
            return null;
        }
        Map map = pathToURLsCache;
        synchronized (map) {
            Object[] v = (Object[])pathToURLsCache.get(path);
            if (v != null) {
                return (URL[])v[0];
            }
        }
        StringTokenizer st = new StringTokenizer(path);
        URL[] urls = new URL[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            urls[i] = new URL(st.nextToken());
            ++i;
        }
        Map map2 = pathToURLsCache;
        synchronized (map2) {
            pathToURLsCache.put(path, new Object[]{urls, new SoftReference<String>(path)});
        }
        return urls;
    }

    private static ClassLoader getRMIContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private ClassLoader findOriginLoader(final URL[] pathURLs, final ClassLoader parent) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PreferredClassProvider.this.findOriginLoader0(pathURLs, parent);
            }
        });
    }

    private ClassLoader findOriginLoader0(URL[] pathURLs, ClassLoader parent) {
        for (ClassLoader ancestor = parent; ancestor != null; ancestor = ancestor.getParent()) {
            Object[] ancestorURLs;
            try {
                ancestorURLs = this.getLoaderAnnotationURLs(ancestor);
            }
            catch (MalformedURLException e) {
                continue;
            }
            if (!Arrays.equals(pathURLs, ancestorURLs)) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "using an existing ancestor class loader which serves the requested codebase urls: {0}, urls: {1}", new Object[]{ancestor, ancestorURLs != null ? Arrays.asList(ancestorURLs) : null});
            }
            return ancestor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader lookupLoader(URL[] urls, ClassLoader parent) {
        if (urls == null) {
            return parent;
        }
        Map map = this.loaderTable;
        synchronized (map) {
            ClassLoader loader;
            LoaderKey key;
            Reference ref;
            while ((ref = this.refQueue.poll()) != null) {
                if (ref instanceof LoaderKey) {
                    key = (LoaderKey)ref;
                    this.loaderTable.remove(key);
                    continue;
                }
                if (!(ref instanceof LoaderEntry)) continue;
                LoaderEntry entry = (LoaderEntry)ref;
                if (entry.removed) continue;
                this.loaderTable.remove(entry.key);
            }
            key = new LoaderKey(urls, parent);
            LoaderEntry entry = (LoaderEntry)this.loaderTable.get(key);
            if (entry == null || (loader = (ClassLoader)entry.get()) == null) {
                if (entry != null) {
                    this.loaderTable.remove(key);
                    entry.removed = true;
                }
                if ((loader = this.findOriginLoader(urls, parent)) == null) {
                    loader = this.createClassLoader(urls, parent, this.requireDlPerm);
                }
                entry = new LoaderEntry(key, loader);
                this.loaderTable.put(key, entry);
            }
            return loader;
        }
    }

    protected ClassLoader createClassLoader(final URL[] urls, final ClassLoader parent, final boolean requireDlPerm) {
        this.checkInitialized();
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new PreferredClassLoader(urls, parent, null, requireDlPerm);
            }
        }, PreferredClassLoader.getLoaderAccessControlContext(urls));
    }

    private static ClassLoader getClassLoader(final Class c) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return c.getClassLoader();
            }
        });
    }

    static {
        $assertionsDisabled = !PreferredClassProvider.class.desiredAssertionStatus();
        logger = Logger.getLogger("net.jini.loader.pref.PreferredClassProvider");
        getClassLoaderPermission = new RuntimePermission("getClassLoader");
        codebaseProperty = null;
        String prop = (String)AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.codebase"));
        if (prop != null && prop.trim().length() > 0) {
            codebaseProperty = prop;
        }
        localLoaders = Collections.synchronizedMap(new WeakHashMap());
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (ClassLoader loader = ClassLoader.getSystemClassLoader(); loader != null; loader = loader.getParent()) {
                    localLoaders.put(loader, null);
                }
                return null;
            }
        });
        pathToURLsCache = new WeakHashMap(5);
    }

    private class LoaderEntry
    extends WeakReference {
        public final LoaderKey key;
        public boolean removed;

        public LoaderEntry(LoaderKey key, ClassLoader loader) {
            super(loader, PreferredClassProvider.this.refQueue);
            this.removed = false;
            this.key = key;
        }
    }

    private class LoaderKey
    extends WeakReference {
        private final URL[] urls;
        private final boolean nullParent;
        private final int hashValue;

        public LoaderKey(URL[] urls, ClassLoader parent) {
            super(parent, PreferredClassProvider.this.refQueue);
            this.urls = urls;
            this.nullParent = parent == null;
            int h = this.nullParent ? 0 : parent.hashCode();
            for (int i = 0; i < urls.length; ++i) {
                h ^= urls[i].hashCode();
            }
            this.hashValue = h;
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object obj) {
            ClassLoader parent;
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LoaderKey)) {
                return false;
            }
            LoaderKey other = (LoaderKey)obj;
            return (this.nullParent ? other.nullParent : (parent = (ClassLoader)this.get()) != null && parent == other.get()) && Arrays.equals(this.urls, other.urls);
        }
    }
}

