/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.policy;

import com.sun.jini.collection.WeakIdentityMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jini.security.GrantPermission;
import net.jini.security.policy.DynamicPolicy;
import net.jini.security.policy.PolicyInitializationException;

public class DynamicPolicyProvider
extends Policy
implements DynamicPolicy {
    private static final String basePolicyClassProperty = "net.jini.security.policy.DynamicPolicyProvider.basePolicyClass";
    private static final String defaultBasePolicyClass = "net.jini.security.policy.PolicyFileProvider";
    private static final ProtectionDomain sysDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return (class$java$lang$Object == null ? (class$java$lang$Object = DynamicPolicyProvider.class$("java.lang.Object")) : class$java$lang$Object).getProtectionDomain();
        }
    });
    private final Policy basePolicy;
    private final boolean cacheBasePerms;
    private final WeakIdentityMap domainPerms = new WeakIdentityMap();
    private final WeakIdentityMap loaderGrants = new WeakIdentityMap();
    private final Grants globalGrants = new Grants();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$jini$security$policy$DynamicPolicyProvider;

    public DynamicPolicyProvider() throws PolicyInitializationException {
        String cname = Security.getProperty(basePolicyClassProperty);
        if (cname == null) {
            cname = defaultBasePolicyClass;
        }
        try {
            this.basePolicy = (Policy)Class.forName(cname).newInstance();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PolicyInitializationException("unable to construct base policy", e);
        }
        this.cacheBasePerms = !(this.basePolicy instanceof DynamicPolicy);
        this.ensureDependenciesResolved();
    }

    public DynamicPolicyProvider(Policy basePolicy) {
        if (basePolicy == null) {
            throw new NullPointerException();
        }
        this.basePolicy = basePolicy;
        this.cacheBasePerms = !(basePolicy instanceof DynamicPolicy);
        this.ensureDependenciesResolved();
    }

    public PermissionCollection getPermissions(CodeSource source) {
        PermissionCollection pc = this.basePolicy.getPermissions(source);
        Permission[] pa = this.globalGrants.get(null);
        for (int i = 0; i < pa.length; ++i) {
            Permission p = pa[i];
            if (pc.implies(p)) continue;
            pc.add(p);
        }
        return pc;
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        return this.getDomainPermissions(domain).getPermissions(domain);
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        return this.getDomainPermissions(domain).implies(permission, domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.basePolicy.refresh();
        if (this.cacheBasePerms) {
            WeakIdentityMap weakIdentityMap = this.domainPerms;
            synchronized (weakIdentityMap) {
                this.domainPerms.clear();
            }
        }
    }

    public boolean grantSupported() {
        return true;
    }

    public void grant(Class cl, Principal[] principals, Permission[] permissions) {
        if (cl != null) {
            DynamicPolicyProvider.checkDomain(cl);
        }
        if (principals != null && principals.length > 0) {
            principals = (Principal[])principals.clone();
            DynamicPolicyProvider.checkNullElements(principals);
        }
        if (permissions == null || permissions.length == 0) {
            return;
        }
        permissions = (Permission[])permissions.clone();
        DynamicPolicyProvider.checkNullElements(permissions);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new GrantPermission(permissions));
        }
        Grants g = cl != null ? this.getLoaderGrants(DynamicPolicyProvider.getClassLoader(cl)) : this.globalGrants;
        g.add(principals, permissions);
    }

    public Permission[] getGrants(Class cl, Principal[] principals) {
        if (cl != null) {
            DynamicPolicyProvider.checkDomain(cl);
        }
        if (principals != null && principals.length > 0) {
            principals = (Principal[])principals.clone();
            DynamicPolicyProvider.checkNullElements(principals);
        }
        List<Permission> l = Arrays.asList(this.globalGrants.get(principals));
        if (cl != null) {
            l = new ArrayList<Permission>(l);
            l.addAll(Arrays.asList(this.getLoaderGrants(DynamicPolicyProvider.getClassLoader(cl)).get(principals)));
        }
        Permissions pc = new Permissions();
        Iterator<Permission> i = l.iterator();
        while (i.hasNext()) {
            Permission p = i.next();
            if (((PermissionCollection)pc).implies(p)) continue;
            ((PermissionCollection)pc).add(p);
        }
        l = Collections.list(((PermissionCollection)pc).elements());
        return l.toArray(new Permission[l.size()]);
    }

    private void ensureDependenciesResolved() {
        this.getDomainPermissions(sysDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DomainPermissions getDomainPermissions(ProtectionDomain pd) {
        DomainPermissions dp;
        WeakIdentityMap weakIdentityMap = this.domainPerms;
        synchronized (weakIdentityMap) {
            dp = (DomainPermissions)this.domainPerms.get(pd);
        }
        if (dp == null) {
            dp = new DomainPermissions(pd);
            this.globalGrants.register(dp);
            if (pd != null) {
                this.getLoaderGrants(pd.getClassLoader()).register(dp);
            }
            weakIdentityMap = this.domainPerms;
            synchronized (weakIdentityMap) {
                this.domainPerms.put(pd, dp);
            }
        }
        return dp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grants getLoaderGrants(ClassLoader ldr) {
        WeakIdentityMap weakIdentityMap = this.loaderGrants;
        synchronized (weakIdentityMap) {
            Grants g = (Grants)this.loaderGrants.get(ldr);
            if (g == null) {
                g = new Grants();
                this.loaderGrants.put(ldr, g);
            }
            return g;
        }
    }

    private static ClassLoader getClassLoader(final Class cl) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.getClassLoader();
            }
        });
    }

    private static void checkDomain(final Class cl) {
        ProtectionDomain pd = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.getProtectionDomain();
            }
        });
        if (pd != sysDomain && pd.getClassLoader() == null) {
            throw new UnsupportedOperationException("ungrantable protection domain");
        }
    }

    private static void checkNullElements(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new NullPointerException();
        }
    }

    private static class WeakGroup {
        private final ReferenceQueue rq = new ReferenceQueue();
        private final Node head = Node.createEmptyList();
        private final Node tail = this.head.getNext();

        WeakGroup() {
        }

        void add(Object obj) {
            if (obj == null) {
                throw new NullPointerException();
            }
            this.processQueue();
            Node newNode = new Node(obj, this.rq);
            newNode.insertAfter(this.head);
        }

        Iterator iterator() {
            this.processQueue();
            return new Iterator(this){
                private Node curNode;
                private Object nextObj;
                private final /* synthetic */ WeakGroup this$0;
                {
                    this.this$0 = this$0;
                    this.curNode = WeakGroup.access$200(this.this$0).getNext();
                    this.nextObj = this.getNext();
                }

                public Object next() {
                    if (this.nextObj == null) {
                        throw new NoSuchElementException();
                    }
                    Object obj = this.nextObj;
                    this.nextObj = this.getNext();
                    return obj;
                }

                public boolean hasNext() {
                    return this.nextObj != null;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private Object getNext() {
                    while (this.curNode != WeakGroup.access$300(this.this$0)) {
                        T obj = this.curNode.get();
                        if (obj != null) {
                            this.curNode = this.curNode.getNext();
                            return obj;
                        }
                        this.curNode.enqueue();
                        this.curNode = this.curNode.getNext();
                    }
                    return null;
                }
            };
        }

        private void processQueue() {
            Node n;
            while ((n = (Node)this.rq.poll()) != null) {
                n.remove();
            }
        }

        static /* synthetic */ Node access$200(WeakGroup x0) {
            return x0.head;
        }

        static /* synthetic */ Node access$300(WeakGroup x0) {
            return x0.tail;
        }

        private static class Node
        extends WeakReference {
            private Node next;
            private Node prev;

            static Node createEmptyList() {
                Node tail;
                Node head = new Node((Object)null);
                head.next = tail = new Node((Object)null);
                tail.prev = head;
                return head;
            }

            private Node(Object obj) {
                super(obj);
            }

            Node(Object obj, ReferenceQueue rq) {
                super(obj, rq);
            }

            void insertAfter(Node pred) {
                Node succ;
                this.next = succ = pred.next;
                this.prev = pred;
                pred.next = this;
                succ.prev = this;
            }

            void remove() {
                this.prev.next = this.next;
                this.next.prev = this.prev;
            }

            Node getNext() {
                return this.next;
            }
        }
    }

    private static class Grants {
        private final Map principalGrants = new HashMap();
        private final WeakGroup scope;

        Grants() {
            PrincipalGrants pg = new PrincipalGrants();
            this.principalGrants.put(Collections.EMPTY_SET, pg);
            this.scope = pg.scope;
        }

        synchronized void add(Principal[] pra, Permission[] pa) {
            Set<Principal> prs = pra != null && pra.length > 0 ? new HashSet<Principal>(Arrays.asList(pra)) : Collections.EMPTY_SET;
            PrincipalGrants pg = (PrincipalGrants)this.principalGrants.get(prs);
            if (pg == null) {
                pg = new PrincipalGrants();
                Iterator i = this.scope.iterator();
                while (i.hasNext()) {
                    DomainPermissions dp = (DomainPermissions)i.next();
                    if (!Grants.containsAll(dp.getPrincipals(), prs)) continue;
                    pg.scope.add(dp);
                }
                this.principalGrants.put(prs, pg);
            }
            ArrayList<Permission> l = new ArrayList<Permission>();
            for (int i = 0; i < pa.length; ++i) {
                Permission p = pa[i];
                if (pg.perms.implies(p)) continue;
                pg.perms.add(p);
                l.add(p);
            }
            if (l.size() > 0) {
                pa = l.toArray(new Permission[l.size()]);
                Iterator i = pg.scope.iterator();
                while (i.hasNext()) {
                    ((DomainPermissions)i.next()).add(pa);
                }
            }
        }

        synchronized Permission[] get(Principal[] pra) {
            Set<Principal> prs = pra != null && pra.length > 0 ? new HashSet<Principal>(Arrays.asList(pra)) : Collections.EMPTY_SET;
            ArrayList<Permission> l = new ArrayList<Permission>();
            Iterator i = this.principalGrants.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                if (!Grants.containsAll(prs, (Set)me.getKey())) continue;
                PrincipalGrants pg = (PrincipalGrants)me.getValue();
                l.addAll(Collections.list(pg.perms.elements()));
            }
            return l.toArray(new Permission[l.size()]);
        }

        synchronized void register(DomainPermissions dp) {
            Set prs = dp.getPrincipals();
            Iterator i = this.principalGrants.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                if (!Grants.containsAll(prs, (Set)me.getKey())) continue;
                PrincipalGrants pg = (PrincipalGrants)me.getValue();
                pg.scope.add(dp);
                ArrayList<Permission> l = Collections.list(pg.perms.elements());
                dp.add(l.toArray(new Permission[l.size()]));
            }
        }

        private static boolean containsAll(Set s1, Set s2) {
            return s1.size() >= s2.size() && s1.containsAll(s2);
        }

        private static class PrincipalGrants {
            final WeakGroup scope = new WeakGroup();
            final PermissionCollection perms = new Permissions();

            PrincipalGrants() {
            }
        }
    }

    private class DomainPermissions {
        private final Set principals;
        private final PermissionCollection perms;
        private final List grants = new ArrayList();
        static final /* synthetic */ boolean $assertionsDisabled;

        DomainPermissions(ProtectionDomain pd) {
            Principal[] pra;
            this.principals = pd != null && (pra = pd.getPrincipals()).length > 0 ? new HashSet<Principal>(Arrays.asList(pra)) : Collections.EMPTY_SET;
            this.perms = DynamicPolicyProvider.this.cacheBasePerms ? DynamicPolicyProvider.this.basePolicy.getPermissions(pd) : null;
        }

        Set getPrincipals() {
            return this.principals;
        }

        synchronized void add(Permission[] pa) {
            for (int i = 0; i < pa.length; ++i) {
                Permission p = pa[i];
                this.grants.add(p);
                if (this.perms == null) continue;
                this.perms.add(p);
            }
        }

        synchronized PermissionCollection getPermissions(ProtectionDomain d) {
            return this.getPermissions(true, d);
        }

        synchronized boolean implies(Permission p, ProtectionDomain domain) {
            if (this.perms != null) {
                return this.perms.implies(p);
            }
            if (DynamicPolicyProvider.this.basePolicy.implies(domain, p)) {
                return true;
            }
            if (this.grants.isEmpty()) {
                return false;
            }
            return this.getPermissions(false, domain).implies(p);
        }

        private PermissionCollection getPermissions(boolean compact, ProtectionDomain domain) {
            if (!$assertionsDisabled && !Thread.holdsLock(this)) {
                throw new AssertionError();
            }
            PermissionCollection pc = DynamicPolicyProvider.this.basePolicy.getPermissions(domain);
            Iterator i = this.grants.iterator();
            while (i.hasNext()) {
                Permission p = (Permission)i.next();
                if (compact && pc.implies(p)) continue;
                pc.add(p);
            }
            return pc;
        }

        static {
            $assertionsDisabled = !(class$net$jini$security$policy$DynamicPolicyProvider == null ? (class$net$jini$security$policy$DynamicPolicyProvider = DynamicPolicyProvider.class$("net.jini.security.policy.DynamicPolicyProvider")) : class$net$jini$security$policy$DynamicPolicyProvider).desiredAssertionStatus();
        }
    }
}

