/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import java.nio.ByteBuffer;
import org.httpkit.HttpUtils;

public abstract class Frame {
    public final byte[] data;

    public Frame(byte[] data) {
        this.data = data;
    }

    public static class TextFrame
    extends Frame {
        private final String msg;

        public TextFrame(byte[] data) {
            super(data);
            this.msg = new String(data, HttpUtils.UTF_8);
        }

        public String getText() {
            return this.msg;
        }
    }

    public static class PongFrame
    extends Frame {
        public PongFrame(byte[] data) {
            super(data);
        }
    }

    public static class PingFrame
    extends Frame {
        public PingFrame(byte[] data) {
            super(data);
        }
    }

    public static class CloseFrame
    extends Frame {
        public static final short CLOSE_NORMAL = 1000;
        public static final short CLOSE_AWAY = 1001;
        public static final short CLOSE_MESG_BIG = 1009;

        public CloseFrame(byte[] data) {
            super(data);
        }

        public int getStatus() {
            if (this.data.length >= 2) {
                return ByteBuffer.wrap(this.data, 0, 2).getShort();
            }
            return 1000;
        }
    }

    public static class BinaryFrame
    extends Frame {
        public BinaryFrame(byte[] data) {
            super(data);
        }
    }
}

