/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import clojure.lang.IFn;
import java.util.Map;
import org.httpkit.HeaderMap;
import org.httpkit.HttpUtils;
import org.httpkit.HttpVersion;
import org.httpkit.server.AsyncChannel;
import org.httpkit.server.ClojureRing;
import org.httpkit.server.HttpRequest;
import org.httpkit.server.RespCallback;

class HttpHandler
implements Runnable {
    final HttpRequest req;
    final RespCallback cb;
    final IFn handler;

    public HttpHandler(HttpRequest req, RespCallback cb, IFn handler) {
        this.req = req;
        this.cb = cb;
        this.handler = handler;
    }

    @Override
    public void run() {
        try {
            Map resp = (Map)this.handler.invoke((Object)ClojureRing.buildRequestMap(this.req));
            if (resp == null) {
                this.cb.run(HttpUtils.HttpEncode(404, new HeaderMap(), null));
            } else {
                Object body = resp.get(ClojureRing.BODY);
                if (!(body instanceof AsyncChannel)) {
                    HeaderMap headers = HeaderMap.camelCase((Map)resp.get(ClojureRing.HEADERS));
                    if (this.req.version == HttpVersion.HTTP_1_0 && this.req.isKeepAlive) {
                        headers.put("Connection", "Keep-Alive");
                    }
                    this.cb.run(HttpUtils.HttpEncode(ClojureRing.getStatus(resp), headers, body));
                }
            }
        }
        catch (Throwable e) {
            this.cb.run(HttpUtils.HttpEncode(500, new HeaderMap(), e.getMessage()));
            HttpUtils.printError((Object)((Object)this.req.method) + " " + this.req.uri, e);
        }
    }
}

