/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.timer;

import clojure.lang.IFn;
import java.util.concurrent.atomic.AtomicBoolean;
import org.httpkit.HttpUtils;
import org.httpkit.PriorityQueue;
import org.httpkit.timer.CancelableFutureTask;

public class TimerService
implements Runnable {
    private final PriorityQueue<CancelableFutureTask> queue = new PriorityQueue();
    private final AtomicBoolean started = new AtomicBoolean(false);
    public static final TimerService SERVICE = new TimerService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CancelableFutureTask scheduleTask(int timeout, IFn task) {
        Object t;
        if (this.started.compareAndSet(false, true)) {
            t = new Thread((Runnable)this, "timer-service");
            ((Thread)t).start();
        }
        t = new CancelableFutureTask(timeout, task, this.queue);
        PriorityQueue<CancelableFutureTask> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.queue.offer((CancelableFutureTask)t);
            this.queue.notify();
        }
        return t;
    }

    public String toString() {
        return "pending=" + this.queue.size() + ", thread started:" + this.started.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean emptyQueueWaited = false;
        while (true) {
            PriorityQueue<CancelableFutureTask> priorityQueue;
            CancelableFutureTask task;
            PriorityQueue<CancelableFutureTask> priorityQueue2 = this.queue;
            synchronized (priorityQueue2) {
                task = this.queue.peek();
            }
            if (task == null) {
                priorityQueue2 = this.queue;
                synchronized (priorityQueue2) {
                    try {
                        this.queue.wait(120000L);
                        if (emptyQueueWaited) {
                            this.started.compareAndSet(true, false);
                            break;
                        }
                        emptyQueueWaited = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            emptyQueueWaited = false;
            long due = task.timeoutTs - System.currentTimeMillis();
            if (due <= 0L) {
                try {
                    task.runTask();
                }
                catch (Exception e) {
                    HttpUtils.printError("In timer: " + task, e);
                }
                priorityQueue = this.queue;
                synchronized (priorityQueue) {
                    if (task == this.queue.peek()) {
                        this.queue.poll();
                    } else {
                        this.queue.remove(task);
                    }
                }
            }
            priorityQueue = this.queue;
            synchronized (priorityQueue) {
                try {
                    this.queue.wait(due);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

