(ns taoensso.timbre.tools.logging
  "clojure.tools.logging.impl/Logger implementation.

  The tools.logging API has some significant limits that native Timbre does not.
  Only use Timbre through tools.logging if you absolutely must (e.g. you're
  working with a legacy codebase)."
  (:require [clojure.tools.logging]
            [taoensso.encore :as enc]
            [taoensso.timbre :as timbre]))

(deftype Logger [logger-ns]
  clojure.tools.logging.impl/Logger

  ;; Limitations: no support for explicit config, nor ns filtering
  (enabled? [_ level] (timbre/log? level))

  ;; Limitations inline
  (write! [_ level throwable message]
    (let [args ; No support for pre-msg raw args
          (if (enc/error? throwable)
            [throwable message]
            [message])]

      #_(timbre/log-call level :p args
        {:config  timbre/*config* ; No support
         :?ns-str nil ; ''
         :?file   nil ; ''
         :?line   nil ; ''
         }))))

(deftype LoggerFactory []
  clojure.tools.logging.impl/LoggerFactory
  (name [_] "Timbre")
  (get-logger [_ logger-ns] (Logger. logger-ns)))

(defn use-timbre []
  (alter-var-root (var clojure.tools.logging/*logger-factory*)
    (constantly (LoggerFactory.))))
