(ns teachscape.etlio.server.config
	(:require [clojure.string              :as str]
			  [teachscape.etlio.tools.cli  :as ecl]
			  [clojure.edn                 :as edn]
			  [clojure.java.io             :as io]))

(def config)

;;
;; API
;;

(defn set-config!
  [m]
  (alter-var-root (var config) (constantly m)))


(defn read-config 
  [config]
  (if config
    (let [config (str/trim config)]
      (if (ecl/valid-config-file? config)
        (edn/read-string (slurp (io/reader config))) ;; read from file
        (if (= (nth config 0) \{)
          (edn/read-string config) ;; if escaped, assume this is a direct config string
          (ecl/exit! 1 (format "configuration %s is not a valid clojure file, nor is it a direct configuration string" config)))))
    {})) ;; return empty when nothing is provided
