(ns teachscape.etlio.tools.cli
  "Command line flags validation and control flow
   functions"
  (:require [me.raynes.fs    :as fs]
            [taoensso.timbre :as log]))

(defn ^:private readable-file?
  [^String path]
  (and path
       (fs/exists? path)
       (fs/file? path)
       (fs/readable? path)))

;;
;; API
;;

(defn exit!
  ([^long code]
     (System/exit code))
  ([^long code ^String message]
     (log/fatal message)
     (System/exit code)))


(defn valid-tasks-directory?
  [^String path]
  (and (fs/exists? path)
       (fs/directory? path)))

(defn valid-task-file?
  [^String path]
  (readable-file? path))

(defn valid-config-file?
  [^String path]
  (readable-file? path))