(ns com.timezynk.mongo.watch
  (:require
   [com.timezynk.mongo.methods.watch :refer [insert-method update-method]]))

(defn on-insert
  "Listen for an `insert!` event.
   
   | Parameter           | Description |
   | ---                 | --- |
   | `collection`        | `keyword/string` The collection. |
   | `callback function` | `function` A callback function that accepts two parameters: |
   |                     | `java.util.Date` Time of event. |
   |                     | `map` The inserted document. |
   
   **Examples**
   
   ```Clojure
   (defn insert-event [time doc]
     ; Do something
   )

   (on-insert :coll insert-event)
   ```"
  {:arglists '([<collection> <callback function>])}
  [coll insert-fn]
  (insert-method coll insert-fn))

(defn on-update
  "Listen for an `update!` event.
   
   | Parameter           | Description |
   | ---                 | --- |
   | `collection`        | `keyword/string` The collection. |
   | `callback function` | `function` A callback function that accepts three parameters: |
   |                     | `java.util.Date` Time of event. |
   |                     | `map` Contains the id of the updated document, plus the fields that were updated. |
   
   **Examples**
   
   ```Clojure
   (defn update-event [time old-doc new-doc]
     ; Do something
   )

   (on-update :coll update-event)
   ```"
  {:arglists '([<collection> <callback function>])}
  [coll update-fn]
  (update-method coll update-fn))
