(ns ^:no-doc com.timezynk.mongo.methods.fetch-and-delete
  (:require
   [com.timezynk.mongo.config :refer [*mongo-session*]])
  (:import [org.bson Document]))

(defmulti fetch-and-delete-method ^Document
  (fn [_coll _query]
    (some? *mongo-session*)))

(defmethod fetch-and-delete-method true [coll query]
  (.findOneAndDelete coll *mongo-session* query))

(defmethod fetch-and-delete-method false [coll query]
  (.findOneAndDelete coll query))
