(ns tzsms.core
  (:require [clojure.string :as s]))

(defn filter-digits [mobile]
  (when mobile
    (s/replace (str mobile) #"\D" "")))

(defn trim-leading-zeros [mobile]
  (when mobile
    (second (re-matches #"0*(\d*)" (str mobile)))))

(defn int-mobile
  "Construct an international mobile number from country code and local mobile number."
  ([mobile]
    (when mobile
      (trim-leading-zeros (filter-digits mobile))))
  ([country-code mobile]
    (when (and country-code mobile)
      (str
        (trim-leading-zeros (filter-digits country-code))
        (trim-leading-zeros (filter-digits mobile))))))

(defprotocol Backend "SMS Sending backend"
  (sms [backend from to message] "Send SMS")
  (status [backend message-id] "Check message delivery status"))
