(ns tzsms.infobip
  (:use tzsms.core
        [slingshot.slingshot :only [throw+]])
  (:require [clj-http.client :as http]
            [clojure.string :as s])
  (:import [java.net URLEncoder]
    [javax.xml.bind.annotation.adapters HexBinaryAdapter]))

(defn query-string [params]
  (let [hexmessage (.marshal (HexBinaryAdapter.) (.getBytes (:SMSText params "") "ISO-8859-1"))]
    (str
      (http/generate-query-string (dissoc params :SMSText))
      "&Binary=" hexmessage
      (when (> (count hexmessage) 320)
        "&Type=LongSMS"))))

(defrecord Infobip [^String username ^String password ^String url]
  Backend
  (sms [this from to message]
    (let [q (query-string {:user (:username this)
                           :password (:password this)
                           :sender from
                           :GSM to
                           :SMSText message})
          response (http/get (str (:url this) "/sendsms/plain?" q) {:insecure? true})
          body (s/trim (:body response ""))]
      (cond
        (re-matches #"^-\d+" body) (throw+ {:type ::infobip-error :error body})
        :else body)))

  (status [this message-id]
    (let [q (http/generate-query-string {:user (:username this)
                                         :password (:password this)
                                         :messageid message-id})]
      (s/trim (:body (http/get (str (:url this) "/dlrpull?" q)))))))
