(ns tzsms.beepsend
  (:use tzsms.core
        [slingshot.slingshot :only [throw+]])
  (:require [clj-http.client :as http]
            [clojure.string :as s])
  (:import [java.net URLEncoder]))

(defn query-string [params]
  (str
    (http/generate-query-string (dissoc params :message))
    "&message="
    (URLEncoder/encode (:message params "") "ISO-8859-1")))

(defrecord Beepsend [^String username ^String password ^String url]
  Backend
  (sms [this from to message]
    (let [q (query-string {:user (:username this)
                           :pass (:password this)
                           :from from
                           :to to
                           :message message})
          response (http/get (str (:url this) "?" q) {:insecure? true})
          body (s/trim (:body response ""))]
      (cond
        (re-matches #"^E\d+" body) (throw+ {:type ::beepsend-error :error body})
        :else body))))
