(ns com.timezynk.useful.s3
  (:require [clojure.java.io :as io])
  (:import [com.amazonaws.auth PropertiesCredentials]
           [com.amazonaws.services.s3
            AmazonS3
            AmazonS3Client]
           [com.amazonaws.services.s3.model
            PutObjectRequest
            ObjectMetadata]))


(def ^{:dynamic true} *s3* nil)

(defn stream [filename]
  (io/input-stream (io/file filename)))

(defn make-client []
  (AmazonS3Client. (PropertiesCredentials. (io/input-stream (io/resource "aws.properties")))))

(defn get-meta [bucket filename]
  (let [^AmazonS3Client s3 (or *s3* (make-client))]
    (try
      (.getObjectMetadata s3 bucket filename)
      (catch Exception e
        nil))))

(defn upload [bucket filename stream & {:keys [content-type
                                               content-length
                                               cache-control]}]
  (let [^AmazonS3Client s3 (or *s3* (make-client))]
    (.putObject s3
      (PutObjectRequest. bucket filename stream
        (doto (ObjectMetadata.)
          (.setContentType (or content-type "application/octet-stream"))
          (.setContentLength (or content-length 0))
          (.setCacheControl (or cache-control "public")))))))

(defn list-objects [bucket prefix]
  (let [^AmazonS3Client s3 (or *s3* (make-client))]
    (.listObjects s3 bucket prefix)))

(defmacro with-s3 [& body]
  `(binding [*s3* (make-client)]
     ~@body))