(ns com.timezynk.useful.email.template
  (:require
   [net.cgrand.enlive-html :as enlive]
   [clojure.string :refer [join]]))

(defn- escaper [m]
  (fn [k]
    (or
     (get m k)
     (str "${" (name k) "}"))))

(defn- moustache [template vars]
  (enlive/at template
             [enlive/any-node] (enlive/replace-vars (escaper vars))))

(defn- transformations [template params]
  (-> template

      (enlive/at [(enlive/attr? :data-lines)]
                 (fn [node]
                   (let [param       (keyword (get-in node [:attrs :data-lines]))
                         content     (get params param [])
                         set-content (enlive/html-content (join "<br>" content))]
                     (set-content node))))

      ;; <div data-container="foo">
      ;;    <!-- content from (:foo param) here -->
      ;; </div>
      (enlive/at [(enlive/attr? :data-container)]
                 (fn [node]
                   (let [param       (keyword (get-in node [:attrs :data-container]))
                         content     (get params param [])
                         set-content (enlive/html-content (apply str content))]
                     (set-content node))))))

(defn- ->str [nodes]
  (apply str (enlive/emit* nodes)))

(defn tmpl->str [tmpl params]
  (-> tmpl
      (moustache params)
      (transformations params)
      ->str))

(defn load-template [path]
  (enlive/html-resource path))

