(ns com.timezynk.useful.measured-future
  (:require
   [clojure.tools.logging :as log]
   [com.timezynk.useful.prometheus.core :as metrics]
   [clojure.test :refer [deftest is testing]])
  (:import [java.lang.management ManagementFactory ThreadMXBean]))

(defonce future-counter (metrics/counter :measured_futures_total
                                         "A counter of the total number of started futures"
                                         :method))

(defonce future-seconds (metrics/counter :measured_futures_seconds
                                         "A counter of the total seconds spent in measured futures"
                                         :method))

(def thread-bean (delay (ManagementFactory/getThreadMXBean)))
(defn thread-cpu-time ^long [] (.getCurrentThreadCpuTime ^ThreadMXBean @thread-bean))

(defmacro measured-future [& body]
  (let [meta (meta &form)
        location (str (:file meta) ":" (:line meta))]
    `(future
       (let [name# ~location
             start-cpu-time# (thread-cpu-time)
             result# (do ~@body)
             finish-cpu-time# (thread-cpu-time)
             cpu-time-diff# (/ (double (- finish-cpu-time# start-cpu-time#)) 1000000000.0)]
         (apply metrics/inc! future-counter [name#])
         (apply metrics/inc-by! future-seconds cpu-time-diff# [name#])
         result#))))

(deftest can-return-result
  (testing "Measured future returns the bodys result"
    (let [f (measured-future (Thread/sleep 10) 10)]
      (is (= 10 @f)))))
