(ns com.timezynk.useful.channel.message)

(def ^{:dynamic true} *reply-channel* nil)

(defrecord ChannelMessage [prio task enqueued-at]
  Comparable
  (compareTo [this o]
    (compare (:prio this) (:prio o))))

(defn make
  "ChannelMessage constructor which sets :enqueued-at to the current time."
  [prio task]
  (ChannelMessage. prio task (System/currentTimeMillis)))

(defn report
  "Human-readable report of the course of the message through the processing
   pipeline. Intended for logging."
  [message wait-time run-time]
  (when-let [t (:task message)]
    (let [{:keys [context topic cname]} t
          new-id (get-in t [:message 0 :id])]
      (format "[%s] %s in %s %d/%d"
              (or context "N/A")
              (cond-> (name topic)
                new-id (str " " new-id))
              (name cname)
              wait-time
              run-time))))
