(ns com.timezynk.useful.json
  (:require
   [cheshire.generate :as json]))

(extend-protocol json/JSONable
  java.time.ZonedDateTime
  (to-json [zdt jg]
    (.writeString jg (.toString zdt)))

  java.time.LocalDateTime
  (to-json [dt jg]
    (.writeString jg (.toString dt)))

  java.time.LocalDate
  (to-json [d jg]
    (.writeString jg (.toString d)))

  java.time.LocalTime
  (to-json [t jg]
    (.writeString jg (.toString t))))
