(ns com.timezynk.useful.rest.middleware
  (:use [slingshot.slingshot :only [try+]])
  (:require [clojure.tools.logging :as log]
            [ring.util.response :as res]))

(def rng (java.util.Random. (System/currentTimeMillis)))

(defn get-client-id [{:keys [headers]}]
  (or (get headers "x-tz-client")
      (get headers :x-tz-client)
      (get headers "user-agent")
      (get headers :user-agent)))

(defn wrap-exceptions [handler]
  (fn [request]
    (try+
      ;(log/info (:request-method handler) (:uri request))
      ;(Thread/sleep (log/spy (Math/abs (* 100 (+ 2.0 (.nextGaussian rng))))))
      (handler request)
      (catch [:type :validation-error] e
        (log/warn e "Validation exception 400" (:request-method request) (:uri request)
                  ", client:" (get-client-id request))
        {:status  400
         :headers {"Content-Type" "application/json"}
         :body    (:errors e)})
      (catch map? e
        (let [status (:code e 500)]
          (log/warn e "Caught slingshot exception" status (:request-method request) (:uri request)
                    ", client:" (get-client-id request))
          {:status status
           :headers {"Content-Type" "application/json"}
           :body    e}))
      (catch Exception e
        (log/error e "Caught exception 500" (:request-method request) (:uri request)
                   ", client:" (get-client-id request))
        {:status 500
         :headers {"Content-Type" "application/json"}
         :body {:error (.getMessage e)}
                :trace (map str (.getStackTrace e))}))))

(defn wrap-nocache [handler]
  (fn [request]
    (when-let [result (handler request)]
      (cond
        (= :post (:request-method request)) (res/header result "Cache-Control" "no-cache")
        (.endsWith ^String (:uri request) ".js") (res/header result "Cache-Control" "max-age=1,must-revalidate,public")
        :else result))))

(defn wrap-cors [handler]
  (fn [request]
    (when-let [result (handler request)]
      (-> result
        (res/header "Access-Control-Allow-Origin" "*")
        (res/header "Access-Control-Max-Age" "600")))))
