(ns com.timezynk.useful.map
  (:require [clojure.core.reducers :as r]))

(defn map->map
  "Recursively copy a map-like object into a vanilla clojure map"
  [proto]
  (if (map? proto)
    (into {} (map #(vector (key %) (map->map (val %))) proto))
    proto))

(defn index-by [f coll]
  (when coll
    (r/reduce
      (fn [m e]
        (assoc m (f e) e))
      {} coll)))

(defn id-map [coll]
  (index-by :id coll))

(defn filter-fields [fields]
  (fn [entries]
    (r/map
      (fn [e]
        (select-keys e fields))
      entries)))

(defn into-vec [entries]
  (into [] entries))

(defn into-set [entries]
  (into #{} entries))

(defn unique-vals [k & colls]
  (loop [[c & r] colls
         values #{}]
    (if c
      (recur r
        (r/reduce
          (fn [res e]
            (conj res (get e k)))
          values c))
      values)))
