(ns com.timezynk.useful.base64
  (:use [clojure.string :only [split join]])
  (:import [org.apache.commons.codec.binary Base64]))

(defn ^"[B" decode [^"[B" bytes]
  (Base64/decodeBase64 bytes))

(defn ^"[B" decode-string [^String s]
  (Base64/decodeBase64 s))

(defn ^"[B" encode [^"[B" bytes]
  (Base64/encodeBase64 bytes))

(defn is-base64? [^"[B" bytes]
  (Base64/isBase64 bytes))

(defn ^String base64-str [^"[B" bytes]
  (Base64/encodeBase64String bytes))

(defn ^String base64-str-urlsafe [^"[B" bytes]
  (Base64/encodeBase64URLSafeString bytes))

(defn ^String vec->b64 [v]
  (join "$" (map base64-str v)))

(defn b64->vec [^String s]
  (map decode-string (split s #"\$")))
