(ns com.timezynk.useful.cancan
  (:use [slingshot.slingshot :only [try+ throw+]])
  (:require [clojure.tools.logging :as log]))

(def ^{:dynamic true} *ability*)

(defn can
  ([action object]
    (can action object (constantly true) *ability*))
  ([action object pred]
    (can action object pred *ability*))
  ([action object pred ability]
    (let [actions (if (sequential? action) action [action])
          predicates (zipmap actions (repeat pred))]
      (swap! ability update-in [object] merge predicates))))

(defn can?
  ([action object]
    (can? action object nil *ability*))
  ([action object instance]
    (can? action object instance *ability*))
  ([action object instance ability]
    (let [pred (or (get-in @ability [:all :all])
                   (get-in @ability [:all action])
                   (get-in @ability [object action])
                   (get-in @ability [object :all]))]
      (when pred
        (pred action object instance)))))

(defn authorize!
  ([action object] (authorize! action object nil *ability*))
  ([action object instance] (authorize! action object instance *ability*))
  ([action object instance ability]
    (if (can? action object instance ability)
      instance
      (throw+ {:error :cancan :action action :object object :instance instance}))))

(defn authorize-all!
  ([action object instances] (authorize-all! action object instances *ability*))
  ([action object instances ability]
    (when-not (every? true? (map #(can? action object % ability) instances))
      (throw+ {:error :cancan :action action :object object :instance instances}))
    instances))

(defmacro with-ability [& body]
  `(binding [*ability* (atom {})]
    ~@body))

(defn wrap-cancan [handler]
  (fn [request]
    (try+
      (with-ability
        (handler request))
      (catch [:error :cancan] e
        (throw+ {:code 401 :error "Unauthorized"})))))
