(ns com.timezynk.useful.rest.current-user)

(def ^{:dynamic true :private true} *user*)

(defmacro with-user [user & body]
  `(let [u# ~user]
     (binding [*user* u#]
       ~@body)))

(defn user-id []
  (:id *user*))

(defn company-id []
  (:company-id *user*))

(defn role []
  (keyword (:role *user*)))
