(ns com.timezynk.useful.channel.message
  (:require [com.timezynk.useful.channel.context :as c]
            [com.timezynk.useful.channel.subscriber.hook :as h]))

(def ^{:dynamic true} *reply-channel* nil)

(defrecord ChannelMessage [prio task enqueued-at]
  Comparable
  (compareTo [this o]
    (compare (:prio this) (:prio o)))
  
  Object
  (toString [this]
    (when-let [task (:task this)]
      (let [{:keys [context topic cname]} task
            new-id (get-in task [:message 0 :id])
            hook (get-in task [:subscriber :f])]
        (format "[%s] %s in %s -> %s"
                (if context
                  (c/pretty-print context)
                  "N/A")
                (cond-> (name topic)
                  new-id (str " " new-id))
                (name cname)
                (h/pretty-print hook))))))

(defmethod print-method ChannelMessage [x ^java.io.Writer w]
  (.write w (str x)))

(defn make
  "ChannelMessage constructor which sets :enqueued-at to the current time."
  [prio task]
  (ChannelMessage. prio task (System/currentTimeMillis)))
