(ns com.timezynk.useful.token
  (:require [com.timezynk.clj-jwt.core :as jwt]
            [com.timezynk.clj-jwt.key :as jwt-key])
  (:import [java.io StringReader]))

(def passphrase
  "Passphrase to the private Timezynk JWT signing key."
  (System/getenv "PRIVATE_KEY_PASSPHRASE"))

(def private-key
  "Private Timezynk JWT signing key."
  (when passphrase
    (-> "PRIVATE_KEY"
        (System/getenv)
        (StringReader.)
        (jwt-key/pem->private-key passphrase))))

(def ISS
  "JWT issuer."
  "https://pro.timezynk.com/session")

(def AUD
  "JWT audience."
  "https://pro.timezynk.com")

(defn claims
  "Builds claims hashmap."
  [& {:keys [company-id role]}]
  {:x-tz-cid (str company-id)
   :x-tz-rol (name role)
   :iss ISS
   :aud AUD})

(defn create
  "JWT-signs `claims` with the private Timezynk key."
  [claims]
  (cond-> claims
    true        (jwt/jwt)
    private-key (jwt/sign :RS256 private-key)
    true        (jwt/to-str)))
