(ns com.timezynk.useful.token
  (:require [clojure.string :as string]
            [clojure.tools.logging :as log]
            [com.timezynk.clj-jwt.core :as jwt]
            [com.timezynk.clj-jwt.key :as jwt-key])
  (:import [java.io StringReader]))

(def passphrase
  "Passphrase to the private Timezynk JWT signing key."
  (System/getenv "PRIVATE_KEY_PASSPHRASE"))

(def private-key
  "Private Timezynk JWT signing key."
  (when passphrase
    (log/warn "PPHR" (->> "PRIVATE_KEY_PASSPHRASE" (System/getenv) (take-last 5) (string/join)))
    (log/warn "PKEY [[" (->> "PRIVATE_KEY" (System/getenv) (take 200) (string/join)))
    (log/warn "PKEY ]]" (->> "PRIVATE_KEY" (System/getenv) (take-last 200) (string/join)))
    (log/warn "PPHR #" (->> "PRIVATE_KEY_PASSPHRASE" System/getenv count))
    (log/warn "PKEY #" (->> "PRIVATE_KEY" System/getenv count))
    (try
      (-> "PRIVATE_KEY"
          (System/getenv)
          (StringReader.)
          (jwt-key/pem->private-key passphrase))
      (catch Exception e
        (log/error e "Failed to initialize JWT key")))))

(def ISS
  "JWT issuer."
  "https://pro.timezynk.com/session")

(def AUD
  "JWT audience."
  "https://pro.timezynk.com")

(defn claims
  "Builds claims hashmap."
  [& {:keys [company-id role]}]
  {:x-tz-cid (str company-id)
   :x-tz-rol (name role)
   :iss ISS
   :aud AUD})

(defn create
  "JWT-signs `claims` with the private Timezynk key."
  [claims]
  (cond-> claims
    true        (jwt/jwt)
    private-key (jwt/sign :RS256 private-key)
    true        (jwt/to-str)))
