(ns com.timezynk.useful.quartzite.cron
  "Helpers to bridge gap between UNIX cron and Quartz cron."
  (:require [clojure.string :as string]
            [clojurewerkz.quartzite.schedule.cron :as cron]))

(defn- classic->quartz [expr]
  (let [parts (string/split expr #" ")
        [minutes hours day-of-month month day-of-week] parts
        day-of-week (if (= "*" day-of-month day-of-week)
                      "?"
                      day-of-week)]
    (if (= 5 (count parts))
      (string/join " " [0 minutes hours day-of-month month day-of-week])
      expr)))

(defn schedule [expr]
  (-> expr classic->quartz cron/cron-schedule cron/schedule))
