(defproject com.timezynk/useful "4.16.0"
  :description "Useful functions"
  :url "https://gitlab.com/timezynk/libs-useful"
  :license {:name "BSD 3 Clause"
            :url  "https://opensource.org/licenses/BSD-3-Clause"}
  :dependencies [[ch.qos.logback/logback-core "1.2.12"]
                 [ch.qos.logback/logback-classic "1.2.12"]
                 [ch.qos.logback.contrib/logback-jackson "0.1.5"]
                 [ch.qos.logback.contrib/logback-json-classic "0.1.5"]
                 [cheshire "5.11.0"]
                 [clj-http "3.12.4"]
                 [clj-jwt "0.1.1"]
                 [clojurewerkz/quartzite "2.2.0" :scope "provided"]
                 [com.fasterxml.jackson.core/jackson-databind "2.11.4"]
                 [com.novemberain/validateur "1.2.0"]
                 [com.slack.api/slack-api-client "1.37.0" :exclusions [org.slf4j/slf4j-api]]
                 [com.sproutsocial/nsq-j "0.9.4"]
                 [com.timezynk/clj-jwt "0.1.2"]
                 [commons-codec "1.15"]
                 [commons-validator "1.8.0"]
                 [compojure "1.7.0" :scope "provided"]
                 [enlive "1.1.6"]
                 [hato "1.0.0"]
                 [io.github.clj-kondo/config-slingshot-slingshot "1.0.0"]
                 [io.prometheus/simpleclient "0.9.0"]
                 [io.prometheus/simpleclient_common "0.9.0"]
                 [io.prometheus/simpleclient_hotspot "0.9.0"]
                 [jbcrypt "0.3"]
                 [joda-time "2.10"]
                 [metosin/malli "0.19.1" :scope "provided"]
                 [org.apache.logging.log4j/log4j-to-slf4j "2.17.2" :exclusions [org.slf4j/slf4j-api]]
                 [org.clojure/clojure "1.11.1" :scope "provided"]
                 [org.clojure/tools.logging "1.2.4"]
                 [org.mongodb/bson "5.1.4" :scope "provided"]
                 [potemkin "0.4.5"]
                 [prismatic/schema "1.4.1"]
                 [slingshot "0.12.2"]
                 [tortue/spy "2.14.0"]]
  :min-lein-version "2.0.0"
  :local-repo ".m2"
  :test2junit-output-dir "test-results"
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v" "--no-sign"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :profiles {:dev {:resource-paths ["resources-dev"]
                   :dependencies [[ns-tracker "0.4.0"]
                                  [org.codehaus.janino/janino "3.1.9"]]}
             :test {:jvm-opts ["-DCLJ_TEST=1"]}
             :kaocha {:dependencies [[lambdaisland/kaocha "1.71.1119"]]
                      :jvm-opts ["-Djdk.tls.client.protocols=TLSv1,TLSv1.1,TLSv1.2"]}}

  :jvm-opts ["-Dclojure.tools.logging.factory=com.timezynk.useful.logger/factory"]
  :aliases {"kaocha" ["with-profile" "+kaocha" "run" "-m" "kaocha.runner"]}
  :test-paths ["src" "test"]
  :plugins [[lein-difftest "2.0.0"]
            [s3-wagon-private "1.1.2"]
            [test2junit "1.4.4"]
            [lein-cljfmt "0.9.0"]
            [lein-pprint "1.3.2"]
            [com.github.clj-kondo/lein-clj-kondo "0.2.1"]]
  :aot [com.timezynk.useful.logback.pii-scrubber])
