(ns com.timezynk.useful.schemas
  "Commonly used Malli schemas."
  (:require [malli.core :as m]
            [com.timezynk.useful.mongo :as um]
            [com.timezynk.useful.predicates :as up]))

(def ObjectId
  (m/-simple-schema
    {:type :object-id
     :pred um/object-id?
     :type-properties {:error/message "not a valid ObjectId"
                       :decode/string um/object-id
                       :json-schema/type "string"
                       :json-schema/format "string"
                       :gen/gen (fn [_] (org.bson.types.ObjectId.))}}))

(def Personnummer
  "Schema of Swedish social security number."
  (m/-simple-schema
    {:type :personnummer
     :pred up/personnummer?
     :type-properties {:error/message "not a valid Swedish SSN"
                       :json-schema/type "string"
                       :json-schema/format "string"
                       :gen/gen (fn [_] (str (+ 1900 (rand-int 200))
                                             (+ 1 (rand-int 12))
                                             (+ 1 (rand-int 28))
                                             "-"
                                             (+ 1000 (rand-int 999))))}}))

(def DomainEvent
  "Schema of event on a Timezynk domain type."
  [:map
   [:operation  [:enum "insert" "update" "delete"]]
   [:collection :string]
   [:new-doc    [:maybe :map]]
   [:old-doc    [:maybe :map]]])

(def YYYYMMDD
  "Schema of a string representing a valid date in YYYYMMDD format."
  (m/-simple-schema
    {:type :yyyymmdd
     :pred up/yyyymmdd?
     :type-properties {:error/message "not a valid YYYYMMDD date"
                       :json-schema/type "string"
                       :json-schema/format "string"
                       :gen/gen (fn [_] (str (+ 1900 (rand-int 200))
                                             (+ 1 (rand-int 12))
                                             (+ 1 (rand-int 28))))}}))

(def YYYY-MM-DD
  "Schema of a string representing a valid date in YYYYMMDD format."
  (m/-simple-schema
    {:type :yyyy-mm-dd
     :pred up/yyyy-mm-dd?
     :type-properties {:error/message "not a valid YYYYMMDD date"
                       :json-schema/type "string"
                       :json-schema/format "string"
                       :gen/gen (fn [_] (str (+ 1900 (rand-int 200))
                                             (+ 1 (rand-int 12))
                                             (+ 1 (rand-int 28))))}}))
