(ns com.timezynk.useful.env)

(def CLJ_ENV
  (or (and (System/getProperty "CLJ_TEST") "test")
      (and (System/getenv "CLJ_TEST") "test")
      (System/getenv "CLJ_ENV")
      "development"))

(def test?
  (= "test" CLJ_ENV))

(def development?
  (= "development" CLJ_ENV))

(def production?
  (= "production" CLJ_ENV))

(defn parse-int-var
  "Integer value found in the environment variable `envvar-name`.
   `fallback` in case of failure."
  ([envvar-name fallback]
   (try
     (-> (System/getenv envvar-name) (Integer/parseInt))
     (catch Exception _ fallback)))
  ([envvar-name]
   (parse-int-var envvar-name nil)))
