(ns com.timezynk.useful.schemas.prismatic
  "Commonly used definitions for Prismatic Schema."
  (:require [schema.core :as s :refer [defschema]]
            [com.timezynk.useful.mongo :as um]))

(def ObjectId
  "Java object representing a MongoDB ID."
  (s/pred um/object-id? 'object-id?))

(defschema DomainEvent
  "Schema of event on a Timezynk domain type."
  {(s/required-key :operation)  (s/enum "insert" "update" "delete")
   (s/required-key :collection) s/Str
   (s/required-key :new-doc)    {s/Any s/Any}
   (s/required-key :old-doc)    (s/maybe {s/Any s/Any})})
