(ns com.timezynk.useful.quartzite.context
  "Provide scheduled jobs with necessary data, e.g. database connection."
  (:require [clojurewerkz.quartzite.conversion :as qc]))

(def dehydrate
  "Turns job context from Clojure data into Quartz format."
  identity)

(defn- parse-symbol [x]
  (try
    (let [v (read-string x)]
      (and (seq? v)
           (-> v (first) (= 'var))
           (second v)))
    (catch Exception _ nil)))

(defn- load-var [sym]
  (-> sym namespace symbol require)
  (find-var sym))

(defn hydrate
  "Turns job context from Quartz format into Clojure data."
  [context]
  (->> context
       (qc/from-job-data)
       (filter (comp parse-symbol key))
       (map (juxt (comp load-var parse-symbol key) val))
       (into {})))
