(ns com.timezynk.useful.test.fixture
  (:require [clojure.tools.logging :as log]
            [clojure.tools.logging.impl :as log-impl]
            [com.timezynk.useful.jwt :as jwt]
            [com.timezynk.useful.test.http :as uhttp]))

(defn without-jwt
  "Disables verification of incoming JWT tokens."
  [f]
  (let [original jwt/verify
        alter-jwt-verify #(alter-var-root (var jwt/verify) (fn [_] %))]
    (try
      (alter-jwt-verify identity)
      (f)
      (finally (alter-jwt-verify original)))))

(defn with-server
  "Points the `http` helper functions at `url`."
  [url]
  (fn [f]
    (binding [uhttp/*base-url* url]
      (f))))

(defn without-logging
  "Disables logging to keep the expected, noisy stacktraces out of the output."
  [f]
  (binding [log/*logger-factory* log-impl/disabled-logger-factory]
    (f)))
