(ns com.timezynk.useful.test.http
  (:require [cheshire.core :as json]
            [clj-http.client :as client]))

(def ^:dynamic *base-url* nil)

(defn parse-body [response]
  (let [{:keys [body]} response]
    (assoc response
           :raw-body body
           :body (try
                   (json/parse-string body true)
                   (catch Exception _ nil)))))

(defn build-url [& uri-fragments]
  (apply str *base-url* uri-fragments))

(defn post-json [token uri-fragment body]
  (-> (build-url uri-fragment)
      (client/post {:oauth-token token
                    :content-type :json
                    :body (json/generate-string body)
                    :throw-exceptions false})
      (parse-body)))

(defn put-json [token uri-fragment body]
  (-> (build-url uri-fragment)
      (client/put {:oauth-token token
                   :content-type :json
                   :body (json/generate-string body)
                   :throw-exceptions false})
      (parse-body)))

(defn get-json
  ([token uri-fragment]
   (get-json token uri-fragment {}))
  ([token uri-fragment query-params]
   (-> (build-url uri-fragment)
       (client/get {:query-params (merge {"access_token" token}
                                         query-params)
                    :accept :json
                    :throw-exceptions false})
       (parse-body))))

(defn delete-json [token uri-fragment & [body]]
   (-> (build-url uri-fragment)
       (client/delete {:query-params {"access_token" token}
                       :accept :json
                       :content-type (when body :json)
                       :body (when body (json/generate-string body))
                       :throw-exceptions false})
       (parse-body)))
