(ns com.timezynk.useful.test.fixture
  (:require [com.timezynk.mongo.util :as mu]
            [com.timezynk.useful.jwt :as jwt]
            [com.timezynk.useful.test.database :as udb]
            [com.timezynk.useful.test.http :as uhttp]))

(defn with-database
  "Attempts to build a fixture which provides the test a database connection.
   `url-var` is the name of the enviroment variable where the connection string
   is expected to be.
   Throws an exception if no environment variable by that name is found."
  [url-var]
  (if-some [url (System/getenv url-var)]
    (fn [f]
      (mu/set-mongo-uri! url)
      (mu/wrap-mongo
        (f)))
    (->> url-var
         (str "No value set for ")
         (IllegalStateException.)
         (throw))))

(defn without-jwt
  "Disables verification of incoming JWT tokens."
  [f]
  (let [original jwt/verify
        alter-jwt-verify #(alter-var-root (var jwt/verify) (fn [_] %))]
    (try
      (alter-jwt-verify identity)
      (f)
      (finally (alter-jwt-verify original)))))

(defn with-drop
  "Deletes all database collections before running."
  [f]
  (udb/clear-db)
  (f))

(defn with-server
  "Points the `http` helper functions at `url`."
  [url]
  (fn [f]
    (binding [uhttp/*base-url* url]
      (f))))
