(ns com.timezynk.useful.test.fixture
  (:require [com.timezynk.useful.jwt :as jwt]
            [com.timezynk.useful.test.http :as uhttp]))

(defn without-jwt
  "Disables verification of incoming JWT tokens."
  [f]
  (let [original jwt/verify
        alter-jwt-verify #(alter-var-root (var jwt/verify) (fn [_] %))]
    (try
      (alter-jwt-verify identity)
      (f)
      (finally (alter-jwt-verify original)))))

(defn with-server
  "Points the `http` helper functions at `url`."
  [url]
  (fn [f]
    (binding [uhttp/*base-url* url]
      (f))))
