(ns com.timezynk.useful.test.http
  (:require [cheshire.core :as json]
            [clj-http.client :as client]))

(def ^:dynamic *base-url* nil)

(defn parse-body [response]
  (let [{:keys [body]} response]
    (assoc response
           :raw-body body
           :body (try
                   (json/parse-string body true)
                   (catch Exception _ nil)))))

(defn build-url [& uri-fragments]
  (apply str *base-url* uri-fragments))

(defn post-json [token uri-fragment body]
  (->> {:content-type :json
        :body (json/generate-string body)
        :throw-exceptions false}
       (merge (when token {:oauth-token token}))
       (client/post (build-url uri-fragment))
       (parse-body)))

(defn put-json [token uri-fragment body]
  (->> {:content-type :json
        :body (json/generate-string body)
        :throw-exceptions false}
       (merge (when token {:oauth-token token}))
       (client/put (build-url uri-fragment))
       (parse-body)))

(defn get-json
  ([token uri-fragment]
   (get-json token uri-fragment {}))
  ([token uri-fragment query-params]
   (->> {:query-params (merge query-params
                              (when token {"access_token" token}))
         :accept :json
         :throw-exceptions false}
        (client/get (build-url uri-fragment))
        (parse-body))))

(defn delete-json [token uri-fragment & [body]]
   (->> {:accept :json
         :content-type (when body :json)
         :body (when body (json/generate-string body))
         :throw-exceptions false}
        (merge (when token {:query-params {"access_token" token}}))
        (client/delete (build-url uri-fragment))
        (parse-body)))
