/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.maven;

import org.apache.commons.lang3.StringUtils;

public class ConnectionStringUtils {
    public static final String AZUREBLOB_WAGONPROTOCOL = "azureblob://";

    public static final String storageConnectionString(String connectionString) {
        String containerName;
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)connectionString) && StringUtils.isNotEmpty((CharSequence)(containerName = ConnectionStringUtils.blobContainer(result = connectionString.startsWith(AZUREBLOB_WAGONPROTOCOL) ? connectionString.substring(AZUREBLOB_WAGONPROTOCOL.length()) : connectionString)))) {
            result = StringUtils.remove((String)result, (String)("/" + containerName));
        }
        return result;
    }

    public static final String wagonProtocol(String connectionString) {
        if (StringUtils.isNotEmpty((CharSequence)connectionString)) {
            String[] parts = StringUtils.split((String)connectionString, (String)"://");
            if (parts != null && parts.length > 0) {
                return parts[0];
            }
            return "";
        }
        return "";
    }

    public static final String blobContainer(String connectionString) {
        String[] parts;
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)connectionString) && (parts = StringUtils.split((String)connectionString, (String)";")) != null && parts.length > 0) {
            for (String part : parts) {
                int containerStartIndex;
                String[] accountNameParts;
                if (!part.startsWith("AccountName=") || (accountNameParts = StringUtils.split((String)part, (String)"=")) == null || accountNameParts.length <= 1 || (containerStartIndex = accountNameParts[1].indexOf(47)) == -1) continue;
                result = accountNameParts[1].substring(containerStartIndex + 1);
            }
        }
        return result;
    }
}

